/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.msg;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationException;
import org.sentrysoftware.wbem.sblim.slp.ServiceURL;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.MsgHeader;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.RequestMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPInputStream;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPOutputStream;

public class AttributeRequest
extends RequestMessage {
    private String iURLStr;
    private List<String> iTagList;
    private List<String> iSPIList;
    private static final int[] ALLOWED_RSPS = new int[]{7};

    public static SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
        return new AttributeRequest(pHdr, pInStr.readStringSet(), pInStr.readString(), pInStr.readStringList(), pInStr.readStringList(), pInStr.readStringList());
    }

    public AttributeRequest(SortedSet<String> pPrevResponderSet, String pURLStr, List<String> pScopeList, List<String> pTagList, List<String> pSPIList) {
        super(6, pPrevResponderSet, pScopeList);
        this.init(pURLStr, pTagList, pSPIList);
    }

    public AttributeRequest(String pLangTag, SortedSet<String> pPrevResponderSet, String pURLStr, List<String> pScopeList, List<String> pTagList, List<String> pSPIList) {
        super(6, pLangTag, pPrevResponderSet, pScopeList);
        this.init(pURLStr, pTagList, pSPIList);
    }

    public AttributeRequest(MsgHeader pHeader, SortedSet<String> pPrevResponderSet, String pURLStr, List<String> pScopeList, List<String> pTagList, List<String> pSPIList) {
        super(pHeader, pPrevResponderSet, pScopeList);
        this.init(pURLStr, pTagList, pSPIList);
    }

    public ServiceURL getServiceURL() {
        return new ServiceURL(this.iURLStr, 65535);
    }

    @Override
    protected boolean serializeRequestBody(SLPOutputStream pOutStr) {
        return pOutStr.write(this.iURLStr) && pOutStr.writeStringList(this.getScopeList()) && pOutStr.writeStringList(this.iTagList) && pOutStr.writeStringList(this.iSPIList);
    }

    @Override
    protected int[] getAllowedResponseIDs() {
        return ALLOWED_RSPS;
    }

    private void init(String pURLStr, List<String> pTagList, List<String> pSPIList) {
        this.iURLStr = pURLStr;
        this.iTagList = pTagList;
        this.iSPIList = pSPIList;
    }
}

