/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.msg;

import java.io.IOException;
import java.util.Random;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationException;
import org.sentrysoftware.wbem.sblim.slp.internal.Convert;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.FunctionIDs;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPInputStream;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPOutputStream;

public class MsgHeader
implements FunctionIDs {
    public static final byte VERSION = 2;
    public static final int RAW_HDR_LEN = 14;
    public static final int OVERFLOW = 32768;
    public static final int FRESH = 16384;
    public static final int MCAST = 8192;
    private static int cXID = -1;
    private int iVersion;
    private int iFunctionID;
    private String iLangTag;
    private boolean iOverflow;
    private boolean iFresh;
    private boolean iMCast;
    private int iXID;
    private byte[] iLangTagBytes;

    public static MsgHeader parse(SLPInputStream pInStr) throws ServiceLocationException, IOException {
        int version = pInStr.read8();
        int fnID = pInStr.read8();
        if (fnID < 1 || fnID > 11) {
            throw new ServiceLocationException(2, "functionID:" + fnID + " is not supported!");
        }
        pInStr.read24();
        int flags = pInStr.read16();
        pInStr.read24();
        int XID = pInStr.read16();
        String langTag = pInStr.readString();
        return new MsgHeader(version, fnID, langTag, (flags & 0x8000) > 0, (flags & 0x4000) > 0, (flags & 0x2000) > 0, XID);
    }

    public MsgHeader(MsgHeader pHdr) {
        this(pHdr.iVersion, pHdr.iFunctionID, pHdr.iLangTag, pHdr.iOverflow, pHdr.iFresh, pHdr.iMCast, pHdr.iXID);
    }

    public MsgHeader(int pVersion, int pFunctionID, String pLangTag, boolean pOverflow, boolean pFresh, boolean pMCast, int pXID) {
        this.iVersion = pVersion;
        this.iFunctionID = pFunctionID;
        this.iLangTag = pLangTag;
        this.iOverflow = pOverflow;
        this.iFresh = pFresh;
        this.iMCast = pMCast;
        this.iXID = pXID;
    }

    public int getVersion() {
        return this.iVersion;
    }

    public int getFunctionID() {
        return this.iFunctionID;
    }

    public String getLangTag() {
        return this.iLangTag;
    }

    public boolean overflows() {
        return this.iOverflow;
    }

    public boolean fresh() {
        return this.iFresh;
    }

    public boolean multicast() {
        return this.iMCast;
    }

    public int getXID() {
        return this.iXID;
    }

    public void setXID(int pXID) {
        this.iXID = pXID;
    }

    public int getSize() {
        byte[] langBytes = this.getLangTagBytes();
        return 14 + langBytes.length;
    }

    public byte[] serialize(int pBodyLength, boolean pOverflow, boolean pSetMultiCastFlag, boolean pKeepXID) {
        SLPOutputStream outStr = new SLPOutputStream();
        outStr.writeNoChk8(2);
        outStr.writeNoChk8(this.iFunctionID);
        outStr.writeNoChk24(this.getSize() + pBodyLength);
        int flags = 0;
        if (pOverflow) {
            flags |= 0x8000;
        }
        if (this.iFresh) {
            flags |= 0x4000;
        }
        if (pSetMultiCastFlag) {
            flags |= 0x2000;
        }
        outStr.writeNoChk16(flags);
        outStr.writeNoChk24(0);
        if (!pKeepXID) {
            this.iXID = MsgHeader.getNewXID();
        }
        outStr.writeNoChk16(this.iXID);
        byte[] langTagBytes = this.getLangTagBytes();
        outStr.writeNoChk16(langTagBytes.length);
        outStr.writeNoChk(langTagBytes);
        return outStr.toByteArray();
    }

    private byte[] getLangTagBytes() {
        if (this.iLangTagBytes != null) {
            return this.iLangTagBytes;
        }
        this.iLangTagBytes = Convert.getBytes(this.iLangTag);
        return this.iLangTagBytes;
    }

    private static int getNewXID() {
        if (cXID < 0) {
            cXID = new Random().nextInt(65536);
            return cXID == 0 ? (cXID = cXID + 1) : cXID;
        }
        ++cXID;
        if ((cXID &= 0xFFFF) == 0) {
            ++cXID;
        }
        return ++cXID;
    }
}

