/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.msg;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationAttribute;
import org.sentrysoftware.wbem.sblim.slp.ServiceType;
import org.sentrysoftware.wbem.sblim.slp.ServiceURL;
import org.sentrysoftware.wbem.sblim.slp.internal.AttributeHandler;
import org.sentrysoftware.wbem.sblim.slp.internal.Convert;
import org.sentrysoftware.wbem.sblim.slp.internal.TRC;

public class SLPOutputStream {
    private static final int MAX_FIELD_SIZE = 65535;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private ByteArrayOutputStream iOutStr = new ByteArrayOutputStream();
    private int iStreamLimit;
    public static final int URL_HDR_LENGTH = 6;

    public SLPOutputStream() {
        this(Integer.MAX_VALUE);
    }

    public SLPOutputStream(int pStreamLimit) {
        this.iStreamLimit = pStreamLimit <= 0 ? Integer.MAX_VALUE : pStreamLimit;
    }

    public int size() {
        return this.iOutStr.size();
    }

    public int freeSpace() {
        return this.iStreamLimit - this.iOutStr.size();
    }

    public byte[] toByteArray() {
        return this.iOutStr.toByteArray();
    }

    public boolean write(byte[] pBytes) {
        if (this.freeSpace() < pBytes.length) {
            return false;
        }
        this.writeNoChk(pBytes);
        return true;
    }

    public boolean write(ServiceType pServType) {
        if (pServType == null) {
            return this.write((String)null);
        }
        return this.write(pServType.toString());
    }

    public boolean write(ServiceURL pURL) {
        String urlStr = pURL.toString();
        byte[] urlStrBytes = Convert.getBytes(urlStr);
        if (this.freeSpace() < 6 + urlStrBytes.length) {
            return false;
        }
        this.writeNoChk8(0);
        this.writeNoChk16(pURL.getLifetime());
        this.writeNoChk16(urlStrBytes.length);
        this.writeNoChk(urlStrBytes);
        this.writeNoChk8(0);
        return true;
    }

    public boolean writeURLList(List<?> pURLList) {
        int i;
        int cnt;
        int n = cnt = pURLList == null ? 0 : pURLList.size();
        if (cnt == 0) {
            return this.write16(cnt);
        }
        SLPOutputStream tmpStr = new SLPOutputStream();
        for (i = 0; i < cnt; ++i) {
            tmpStr.write((ServiceURL)pURLList.get(i));
            if (this.freeSpace() < tmpStr.size() + 2) break;
        }
        this.writeNoChk16(i);
        this.writeNoChk(tmpStr.toByteArray());
        return i == cnt;
    }

    public boolean writeServTypeList(List<?> pServTypeList) {
        return this.writeServTypeList(pServTypeList == null ? null : pServTypeList.iterator());
    }

    public boolean writeServTypeList(Iterator<?> pServTypeItr) {
        if (pServTypeItr == null) {
            return this.writeStringList((Iterator<String>)null);
        }
        ArrayList<String> servTypeList = new ArrayList<String>();
        while (pServTypeItr.hasNext()) {
            servTypeList.add(((ServiceType)pServTypeItr.next()).toString());
        }
        return this.writeStringList(servTypeList);
    }

    public boolean writeAttributeList(List<?> pAttrList) {
        return this.writeAttributeList(pAttrList == null ? null : pAttrList.iterator());
    }

    public boolean writeAttributeList(Iterator<?> pAttrItr) {
        if (pAttrItr == null) {
            return this.writeStringList((Iterator<String>)null);
        }
        ArrayList<String> attrStrList = new ArrayList<String>();
        while (pAttrItr.hasNext()) {
            attrStrList.add(AttributeHandler.buildString((ServiceLocationAttribute)pAttrItr.next()));
        }
        return this.writeStringList(attrStrList, null);
    }

    public boolean writeAuthBlockList(List<?> pAuthBlockList) {
        int cnt;
        int n = cnt = pAuthBlockList == null ? 0 : pAuthBlockList.size();
        if (cnt != 0) {
            TRC.error("Handling of non empty authentication block list is not implemented!");
        }
        return this.write8(0);
    }

    public boolean write(String pStr) {
        return this.write(pStr, "(),\\!<=>~");
    }

    public boolean write(String pStr, String pReservedChars) {
        byte[] bytes;
        byte[] byArray = bytes = pStr == null ? EMPTY_BYTES : Convert.getBytes(Convert.escape(pStr, pReservedChars));
        if (bytes.length > 65535) {
            return false;
        }
        if (this.freeSpace() < bytes.length + 2) {
            return false;
        }
        this.writeNoChk16(bytes.length);
        this.writeNoChk(bytes);
        return true;
    }

    public boolean writeStringList(List<String> pStrList) {
        return this.writeStringList(pStrList == null ? null : pStrList.iterator());
    }

    public boolean writeStringList(Iterator<String> pStrListItr) {
        return this.writeStringList(pStrListItr, "(),\\!<=>~");
    }

    public boolean writeStringList(List<String> pStrList, String pReservedChars) {
        return this.writeStringList(pStrList == null ? null : pStrList.iterator(), pReservedChars);
    }

    public boolean writeStringList(Iterator<String> pStrListItr, String pReservedChars) {
        ByteArrayOutputStream listByteStr = new ByteArrayOutputStream();
        boolean first = true;
        boolean allWritten = true;
        if (pStrListItr != null) {
            while (pStrListItr.hasNext()) {
                StringBuffer strBuf = new StringBuffer();
                String listItemStr = Convert.escape(pStrListItr.next(), pReservedChars);
                if (first) {
                    first = false;
                } else {
                    strBuf.append(',');
                }
                strBuf.append(listItemStr);
                byte[] listItemBytes = Convert.getBytes(strBuf.toString());
                int currentSize = listByteStr.size() + listItemBytes.length;
                if (currentSize > 65535 || currentSize + 2 > this.freeSpace()) {
                    allWritten = false;
                    break;
                }
                listByteStr.write(listItemBytes, 0, listItemBytes.length);
            }
        }
        byte[] listBytes = listByteStr.toByteArray();
        this.writeNoChk16(listBytes.length);
        this.writeNoChk(listBytes);
        return allWritten;
    }

    public boolean write8(int pValue) {
        if (this.freeSpace() < 1) {
            return false;
        }
        this.writeNoChk8(pValue);
        return true;
    }

    public boolean write16(int pValue) {
        if (this.freeSpace() < 2) {
            return false;
        }
        this.writeNoChk16(pValue);
        return true;
    }

    public boolean write24(int pValue) {
        if (this.freeSpace() < 3) {
            return false;
        }
        this.writeNoChk24(pValue);
        return true;
    }

    public boolean write32(long pValue) {
        if (this.freeSpace() < 4) {
            return false;
        }
        this.writeNoChk32(pValue);
        return true;
    }

    public void writeNoChk(byte[] pBytes) {
        this.iOutStr.write(pBytes, 0, pBytes.length);
    }

    public void writeNoChk8(int pValue) {
        this.iOutStr.write(pValue);
    }

    public void writeNoChk16(int pValue) {
        this.iOutStr.write(pValue >> 8 & 0xFF);
        this.iOutStr.write(pValue & 0xFF);
    }

    public void writeNoChk24(int pValue) {
        this.iOutStr.write(pValue >> 16 & 0xFF);
        this.writeNoChk16(pValue);
    }

    public void writeNoChk32(long pValue) {
        this.iOutStr.write((int)(pValue >> 24 & 0xFFL));
        this.writeNoChk24((int)pValue);
    }
}

