/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.msg;

import java.io.IOException;
import java.util.List;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationAttribute;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationException;
import org.sentrysoftware.wbem.sblim.slp.ServiceURL;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.MsgHeader;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPInputStream;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPOutputStream;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SerializeOption;

public class ServiceRegistration
extends SLPMessage {
    private ServiceURL iServURL;
    private List<String> iScopeList;
    private List<ServiceLocationAttribute> iAttrList;
    private List<?> iAuthBlockList;

    public static SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
        ServiceURL url = pInStr.readURL();
        pInStr.readServiceType();
        return new ServiceRegistration(pHdr, url, pInStr.readStringList(), pInStr.readAttributeList(), pInStr.readAuthBlockList());
    }

    public ServiceRegistration(ServiceURL pServURL, List<String> pScopeList, List<ServiceLocationAttribute> pAttrList, List<?> pAuthBlockList) {
        super(3);
        this.init(pServURL, pScopeList, pAttrList, pAuthBlockList);
    }

    public ServiceRegistration(String pLangTag, ServiceURL pServURL, List<String> pScopeList, List<ServiceLocationAttribute> pAttrList, List<?> pAuthBlockList) {
        super(3, pLangTag);
        this.init(pServURL, pScopeList, pAttrList, pAuthBlockList);
    }

    public ServiceRegistration(MsgHeader pHeader, ServiceURL pServURL, List<String> pScopeList, List<ServiceLocationAttribute> pAttrList, List<?> pAuthBlockList) {
        super(pHeader);
        this.init(pServURL, pScopeList, pAttrList, pAuthBlockList);
    }

    public ServiceURL getServiceURL() {
        return this.iServURL;
    }

    public List<String> getScopeList() {
        return this.iScopeList;
    }

    public List<ServiceLocationAttribute> getAttributeList() {
        return this.iAttrList;
    }

    @Override
    protected boolean serializeBody(SLPOutputStream pOutStr, SerializeOption pOption) {
        return pOutStr.write(this.iServURL) && pOutStr.write(this.iServURL.getServiceType()) && pOutStr.writeStringList(this.iScopeList) && pOutStr.writeAttributeList(this.iAttrList) && pOutStr.writeAuthBlockList(this.iAuthBlockList);
    }

    private void init(ServiceURL pServURL, List<String> pScopeList, List<ServiceLocationAttribute> pAttrList, List<?> pAuthBlockList) {
        this.iServURL = pServURL;
        this.iScopeList = pScopeList;
        this.iAttrList = pAttrList;
        this.iAuthBlockList = pAuthBlockList;
    }
}

