/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.msg;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationException;
import org.sentrysoftware.wbem.sblim.slp.ServiceType;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.MsgHeader;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.RequestMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPInputStream;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPOutputStream;

public class ServiceRequest
extends RequestMessage {
    private ServiceType iServiceType;
    private String iPredicate;
    private String iSlpSpi;
    private static final int[] ALLOWED_RSPS = new int[]{2, 8, 11};

    public static SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
        return new ServiceRequest(pHdr, pInStr.readStringSet(), pInStr.readServiceType(), pInStr.readStringList(), pInStr.readString(), pInStr.readString());
    }

    public ServiceRequest(String pLangTag, SortedSet<String> pPrevResponderSet, ServiceType pServiceType, List<String> pScopeList, String pPredicate, String pSlpSpi) {
        super(1, pLangTag, pPrevResponderSet, pScopeList);
        this.init(pServiceType, pPredicate, pSlpSpi);
    }

    public ServiceRequest(SortedSet<String> pPrevResponderSet, ServiceType pServiceType, List<String> pScopeList, String pPredicate, String pSlpSpi) {
        super(1, pPrevResponderSet, pScopeList);
        this.init(pServiceType, pPredicate, pSlpSpi);
    }

    public ServiceRequest(MsgHeader pHeader, SortedSet<String> pPrevResponderSet, ServiceType pServiceType, List<String> pScopeList, String pPredicate, String pSlpSpi) {
        super(pHeader, pPrevResponderSet, pScopeList);
        this.init(pServiceType, pPredicate, pSlpSpi);
    }

    public ServiceType getServiceType() {
        return this.iServiceType;
    }

    @Override
    protected boolean serializeRequestBody(SLPOutputStream pOutStr) {
        return pOutStr.write(this.iServiceType) && pOutStr.writeStringList(this.getScopeList()) && pOutStr.write(this.iPredicate) && pOutStr.write(this.iSlpSpi);
    }

    @Override
    protected int[] getAllowedResponseIDs() {
        return ALLOWED_RSPS;
    }

    private void init(ServiceType pServiceType, String pPredicate, String pSlpSpi) {
        this.iServiceType = pServiceType;
        this.iPredicate = pPredicate;
        this.iSlpSpi = pSlpSpi;
    }
}

