/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.ua;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.DADescriptor;

public class DACache {
    private static TreeMap<String, ScopeEntry> cScopeMap = new TreeMap();

    public static synchronized List<String> getDiscoverableScopeList(List<String> pScopes) {
        if (pScopes == null || pScopes.size() == 0) {
            return null;
        }
        ArrayList<String> scopeList = null;
        for (String scope : pScopes) {
            ScopeEntry scopeEntry = cScopeMap.get(scope);
            if (scopeEntry != null && scopeEntry.valid()) continue;
            if (scopeList == null) {
                scopeList = new ArrayList<String>();
            }
            scopeList.add(scope);
        }
        return scopeList;
    }

    public static synchronized List<String> getDAList(List<String> pScopes) {
        if (cScopeMap == null) {
            return null;
        }
        TreeSet<String> daSet = new TreeSet<String>();
        for (String scope : pScopes) {
            Iterator<DADescriptor> descItr;
            ScopeEntry scopeEntry = cScopeMap.get(scope);
            if (scopeEntry == null || (descItr = scopeEntry.getDADescriptorItr()) == null) continue;
            while (descItr.hasNext()) {
                daSet.add(descItr.next().getURL());
            }
        }
        return new ArrayList<String>(daSet);
    }

    public static synchronized void setDAList(List<String> pScopes, List<DADescriptor> pDADescriptors) {
        if (pScopes == null || pDADescriptors == null) {
            return;
        }
        for (String scope : pScopes) {
            TreeSet<DADescriptor> daDescsForScope = null;
            for (DADescriptor daDesc : pDADescriptors) {
                if (!daDesc.hasScope(scope)) continue;
                if (daDescsForScope == null) {
                    daDescsForScope = new TreeSet<DADescriptor>();
                }
                daDescsForScope.add(daDesc);
            }
            cScopeMap.put(scope, new ScopeEntry(daDescsForScope));
        }
    }

    static long getSecs() {
        return new Date().getTime() / 1000L;
    }

    private static class ScopeEntry {
        private long iTimeOfDiscovery;
        private TreeSet<DADescriptor> iDADescriptors;

        public ScopeEntry(TreeSet<DADescriptor> pDADescriptors) {
            this.iDADescriptors = pDADescriptors;
            this.iTimeOfDiscovery = DACache.getSecs();
        }

        public boolean valid() {
            return DACache.getSecs() - this.iTimeOfDiscovery <= 90L;
        }

        public Iterator<DADescriptor> getDADescriptorItr() {
            return this.iDADescriptors == null ? null : this.iDADescriptors.iterator();
        }
    }
}

