/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.ua;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import org.sentrysoftware.wbem.sblim.slp.internal.TRC;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ReplyMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.ua.DatagramRequester;

public class ResultTable
implements Iterator<Object> {
    private ArrayList<DatagramRequester> iRequesters = new ArrayList();
    private ArrayList<Exception> iExceptions = new ArrayList();
    private LinkedHashSet<Object> iInSet = new LinkedHashSet();
    private LinkedHashSet<Object> iOutSet = new LinkedHashSet();

    public synchronized void registerRequester(DatagramRequester pReq) {
        for (int i = 0; i < this.iRequesters.size(); ++i) {
            if (pReq != this.iRequesters.get(i)) continue;
            return;
        }
        this.iRequesters.add(pReq);
    }

    public synchronized void unregisterRequester(DatagramRequester pReq) {
        for (int i = 0; i < this.iRequesters.size(); ++i) {
            if (pReq != this.iRequesters.get(i)) continue;
            this.iRequesters.remove(i);
            if (this.iRequesters.size() == 0) {
                this.wakeUp();
            }
            return;
        }
    }

    public void addResults(ReplyMessage pReplyMsg) {
        this.addResults(pReplyMsg.getResultIterator());
    }

    public synchronized void addResults(Iterator<?> pResItr) {
        if (pResItr == null) {
            return;
        }
        while (pResItr.hasNext()) {
            this.addResult(pResItr.next());
        }
        if (this.iInSet.size() > 0) {
            this.wakeUp();
        }
    }

    public synchronized void addExceptions(ReplyMessage pReplyMsg) {
        this.addExceptions(pReplyMsg.getExceptionIterator());
    }

    public synchronized void addExceptions(Iterator<?> pExceptionItr) {
        if (pExceptionItr == null) {
            return;
        }
        while (pExceptionItr.hasNext()) {
            this.addException((Exception)pExceptionItr.next());
        }
    }

    public synchronized void addException(Exception pE) {
        this.iExceptions.add(pE);
        if (this.iExceptions.size() > 0) {
            this.wakeUp();
        }
    }

    public synchronized int getTotalResponses() {
        return this.iOutSet.size() + this.iInSet.size();
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.hasData()) {
            return true;
        }
        if (this.iRequesters.size() == 0) {
            return false;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            TRC.error(e);
        }
        return this.hasData();
    }

    @Override
    public synchronized Object next() throws NoSuchElementException {
        Iterator itr = this.iInSet.iterator();
        Object res = itr.next();
        this.iInSet.remove(res);
        this.iOutSet.add(res);
        return res;
    }

    public Object nextException() throws NoSuchElementException {
        Iterator<Exception> itr = this.iExceptions.iterator();
        Exception res = itr.next();
        this.iExceptions.remove(res);
        return res;
    }

    public boolean hasMoreExceptions() {
        return this.iExceptions.size() > 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void addResult(Object pResult) {
        if (this.iOutSet.contains(pResult) || this.iInSet.contains(pResult)) {
            return;
        }
        this.iInSet.add(pResult);
    }

    private void wakeUp() {
        try {
            this.notifyAll();
        }
        catch (IllegalMonitorStateException e) {
            TRC.error(e);
        }
    }

    private boolean hasData() {
        return this.iInSet.size() > 0;
    }
}

