/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.ua;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationEnumeration;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationException;
import org.sentrysoftware.wbem.sblim.slp.ServiceURL;
import org.sentrysoftware.wbem.sblim.slp.internal.SLPDefaults;
import org.sentrysoftware.wbem.sblim.slp.internal.TRC;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.DADescriptor;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.RequestMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceRequest;
import org.sentrysoftware.wbem.sblim.slp.internal.ua.DACache;
import org.sentrysoftware.wbem.sblim.slp.internal.ua.DatagramRequester;
import org.sentrysoftware.wbem.sblim.slp.internal.ua.ResultTable;

public class SLEnumerationImpl
implements ServiceLocationEnumeration {
    private RequestMessage iReqMsg;
    private ResultTable iResultTable;
    private List<InetAddress> iDAList;
    private boolean iInited = false;
    private boolean iIsDASrvRequest;
    private DatagramRequester iMCastRequester;

    public SLEnumerationImpl(RequestMessage pReqMsg, List<InetAddress> pDAList) {
        this.iReqMsg = pReqMsg;
        this.iResultTable = new ResultTable();
        this.iDAList = pDAList;
        this.iIsDASrvRequest = this.isDASrvRequest();
    }

    @Override
    public Object next() throws NoSuchElementException {
        Object obj = this.iResultTable.next();
        if (obj instanceof Exception) {
            throw new RuntimeException((Exception)obj);
        }
        if (this.iIsDASrvRequest) {
            DADescriptor daDesc = (DADescriptor)obj;
            return new ServiceURL(daDesc.getURL(), 65535);
        }
        return obj;
    }

    @Override
    public Object nextException() throws NoSuchElementException {
        return this.iResultTable.nextException();
    }

    @Override
    public boolean hasMoreExceptions() {
        return this.iResultTable.hasMoreExceptions();
    }

    @Override
    public boolean hasMoreElements() {
        if (!this.iInited) {
            List<InetAddress> daList = null;
            if (!this.iIsDASrvRequest) {
                try {
                    daList = this.getDAList(this.iReqMsg.getScopeList());
                }
                catch (Exception e) {
                    throw new RuntimeException(new ServiceLocationException(10, (Throwable)e));
                }
            }
            try {
                if (daList == null || daList.size() == 0) {
                    this.setupMulticasting();
                } else {
                    this.setupUnicasting(daList);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.iInited = true;
        }
        return this.iResultTable.hasNext();
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        return this.next();
    }

    public int getPort() {
        return this.iMCastRequester == null ? -1 : this.iMCastRequester.getPort();
    }

    private boolean isDASrvRequest() {
        if (!(this.iReqMsg instanceof ServiceRequest)) {
            return false;
        }
        ServiceRequest srvReq = (ServiceRequest)this.iReqMsg;
        return SLPDefaults.DA_SERVICE_TYPE.equals(srvReq.getServiceType());
    }

    private List<InetAddress> getDAList(List<String> pScopes) throws UnknownHostException, IOException {
        if (this.iDAList != null && this.iDAList.size() > 0) {
            return this.iDAList;
        }
        List<String> scopes = DACache.getDiscoverableScopeList(pScopes);
        if (scopes != null) {
            ResultTable resultTable = new ResultTable();
            ServiceRequest srvReq = new ServiceRequest(null, SLPDefaults.DA_SERVICE_TYPE, scopes, null, null);
            DatagramRequester requester = new DatagramRequester(srvReq, resultTable);
            requester.start(false);
            if (resultTable.hasNext()) {
                ArrayList<DADescriptor> daList = new ArrayList<DADescriptor>();
                while (resultTable.hasNext()) {
                    try {
                        daList.add((DADescriptor)resultTable.next());
                    }
                    catch (RuntimeException e) {
                        TRC.warning(e.getMessage(), e);
                    }
                }
                DACache.setDAList(scopes, daList);
            }
        }
        return this.getInetAddresses(DACache.getDAList(pScopes));
    }

    private List<InetAddress> getInetAddresses(List<String> pAddrStrList) {
        if (pAddrStrList == null) {
            return null;
        }
        ArrayList<InetAddress> list = new ArrayList<InetAddress>(pAddrStrList.size());
        for (String srvURLStr : pAddrStrList) {
            try {
                ServiceURL srvURL = new ServiceURL(srvURLStr, 10800);
                list.add(InetAddress.getByName(srvURL.getURLPath()));
            }
            catch (Exception e) {
                TRC.error("Failed to get InetAddress for srvURLStr=" + srvURLStr, e);
            }
        }
        TRC.info("number of discovered DAs:" + list.size());
        return list;
    }

    private void setupUnicasting(List<InetAddress> pDAList) throws IOException {
        for (InetAddress address : pDAList) {
            new DatagramRequester(this.iReqMsg, this.iResultTable, address).start(true);
        }
    }

    private void setupMulticasting() throws ServiceLocationException, IOException {
        try {
            this.iMCastRequester = new DatagramRequester(this.iReqMsg, this.iResultTable);
            this.iMCastRequester.start(true);
        }
        catch (UnknownHostException e) {
            throw new ServiceLocationException(19, (Throwable)e);
        }
    }
}

