/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import org.sentrysoftware.jawk.util.AwkLogger;
import org.sentrysoftware.jawk.util.ScriptSource;
import org.slf4j.Logger;

public class ScriptFileSource
extends ScriptSource {
    private static final Logger LOG = AwkLogger.getLogger(ScriptFileSource.class);
    private String filePath;
    private Reader fileReader;
    private InputStream fileInputStream;

    public ScriptFileSource(String filePath) {
        super(filePath, null, filePath.endsWith(".ai"));
        this.filePath = filePath;
        this.fileReader = null;
        this.fileInputStream = null;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public Reader getReader() {
        if (this.fileReader == null && !this.isIntermediate()) {
            try {
                this.fileReader = new FileReader(this.filePath);
            }
            catch (FileNotFoundException ex) {
                LOG.error("Failed to open script source for reading: " + this.filePath, (Throwable)ex);
            }
        }
        return this.fileReader;
    }

    @Override
    public InputStream getInputStream() {
        if (this.fileInputStream == null && this.isIntermediate()) {
            try {
                this.fileInputStream = new FileInputStream(this.filePath);
            }
            catch (FileNotFoundException ex) {
                LOG.error("Failed to open script source for reading: " + this.filePath, (Throwable)ex);
            }
        }
        return this.fileInputStream;
    }
}

