/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.jawk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.sentrysoftware.jawk.backend.AVM;
import org.sentrysoftware.jawk.ext.JawkExtension;
import org.sentrysoftware.jawk.frontend.AwkParser;
import org.sentrysoftware.jawk.frontend.AwkSyntaxTree;
import org.sentrysoftware.jawk.intermediate.AwkTuples;
import org.sentrysoftware.jawk.util.AwkSettings;
import org.sentrysoftware.jawk.util.ScriptSource;
import org.sentrysoftware.metricshub.engine.awk.UniformPrintStream;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.JawkSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.ICompositeSourceScriptExtension;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceUpdaterProcessor;
import org.sentrysoftware.metricshub.engine.strategy.utils.EmbeddedFileHelper;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.jawk.JawkSourceExtensionRuntimeException;
import org.sentrysoftware.metricshub.extension.jawk.MetricsHubExtensionForJawk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JawkSourceExtension
implements ICompositeSourceScriptExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JawkSourceExtension.class);
    private static final Map<String, AwkTuples> AWK_CODE_MAP = new ConcurrentHashMap<String, AwkTuples>();
    private static final Map<String, Map<String, Map<String, JawkExtension>>> EXTENSIONS_MAP = new ConcurrentHashMap<String, Map<String, Map<String, JawkExtension>>>();

    public boolean isValidSource(Source source) {
        return source instanceof JawkSource;
    }

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager, SourceProcessor sourceProcessor) {
        String inputContent;
        Optional maybeEmbeddedFile;
        String hostname = telemetryManager.getHostname();
        if (source == null) {
            log.warn("Hostname {} - Awk Source cannot be null, the Awk operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        if (!(source instanceof JawkSource)) {
            log.warn("Hostname {} - Awk Source is invalid, the Awk operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        JawkSource jawkSource = (JawkSource)source;
        String script = jawkSource.getScript();
        if (!MetricsHubConstants.FILE_PATTERN.matcher(script).find()) {
            maybeEmbeddedFile = Optional.of(EmbeddedFile.fromString((String)script));
        } else {
            try {
                maybeEmbeddedFile = EmbeddedFileHelper.findEmbeddedFile((String)script, (Map)telemetryManager.getEmbeddedFiles(connectorId), (String)hostname, (String)connectorId);
            }
            catch (Exception exception) {
                log.warn("Hostname {} - Awk Operation script {} has not been set correctly.", (Object)hostname, (Object)script);
                return SourceTable.empty();
            }
        }
        if (maybeEmbeddedFile.isEmpty()) {
            log.warn("Hostname {} - Awk Operation script {} embedded file can't be found.", (Object)hostname, (Object)script);
            return SourceTable.empty();
        }
        EmbeddedFile embeddedFile = (EmbeddedFile)maybeEmbeddedFile.get();
        String awkScript = embeddedFile.getContentAsString();
        log.debug("Hostname {} - Awk Operation. AWK Script:\n{}\n", (Object)hostname, (Object)awkScript);
        AwkSettings settings = new AwkSettings();
        String input = jawkSource.getInput();
        if (input != null && !input.isEmpty() && (inputContent = SourceUpdaterProcessor.replaceSourceReferenceContent((String)input, (TelemetryManager)telemetryManager, (String)connectorId, (String)"Awk", (Object)source.getKey())) != null && !inputContent.isEmpty()) {
            settings.setInput(new ByteArrayInputStream(inputContent.getBytes(StandardCharsets.UTF_8)));
        }
        ByteArrayOutputStream resultBytesStream = new ByteArrayOutputStream();
        UniformPrintStream resultStream = new UniformPrintStream((OutputStream)resultBytesStream);
        settings.setOutputStream((PrintStream)resultStream);
        settings.setCatchIllegalFormatExceptions(true);
        settings.setDefaultRS("\n");
        String hostId = telemetryManager.getHostConfiguration().getHostId();
        MetricsHubExtensionForJawk metricsHubExtensionForJawk = MetricsHubExtensionForJawk.builder().sourceProcessor(sourceProcessor).hostname(telemetryManager.getHostname()).connectorId(connectorId).build();
        Map connectorMap = EXTENSIONS_MAP.computeIfAbsent(hostId, id -> new ConcurrentHashMap());
        Map extensions = connectorMap.computeIfAbsent(connectorId, id -> Arrays.stream(metricsHubExtensionForJawk.extensionKeywords()).collect(Collectors.toMap(key -> key, key -> metricsHubExtensionForJawk)));
        AVM avm = new AVM(settings, extensions);
        try {
            AwkTuples tuple = AWK_CODE_MAP.computeIfAbsent(awkScript, code -> JawkSourceExtension.getIntermediateCode(code, extensions));
            avm.interpret(tuple);
            SourceTable sourceTable = new SourceTable();
            sourceTable.setRawData(resultBytesStream.toString());
            sourceTable.setTable(SourceTable.csvToTable((String)sourceTable.getRawData(), (String)";"));
            return sourceTable;
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)connectorId, (String)source.getKey(), (String)"AwkSource script", (String)hostname, (Throwable)e);
            return SourceTable.empty();
        }
    }

    public static AwkTuples getIntermediateCode(String script, Map<String, JawkExtension> extensions) throws JawkSourceExtensionRuntimeException {
        ScriptSource awkHeader = new ScriptSource("Header", new StringReader("BEGIN { ORS = RS = \"\\n\"; }"), false);
        ScriptSource awkSource = new ScriptSource("Body", new StringReader(script), false);
        ArrayList<ScriptSource> sourceList = new ArrayList<ScriptSource>();
        sourceList.add(awkHeader);
        sourceList.add(awkSource);
        AwkTuples tuples = new AwkTuples();
        AwkParser parser = new AwkParser(false, false, extensions);
        try {
            AwkSyntaxTree ast = parser.parse(sourceList);
            if (ast != null) {
                ast.semanticAnalysis();
                ast.semanticAnalysis();
                if (ast.populateTuples(tuples) != 0) {
                    throw new ParseException("Syntax problem with the Awk script", 0);
                }
                tuples.postProcess();
                parser.populateGlobalVariableNameToOffsetMappings(tuples);
            }
        }
        catch (Exception e) {
            throw new JawkSourceExtensionRuntimeException(e.getMessage(), e);
        }
        return tuples;
    }
}

