/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.jawk;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.sentrysoftware.jawk.NotImplementedError;
import org.sentrysoftware.jawk.ext.AbstractExtension;
import org.sentrysoftware.jawk.ext.JawkExtension;
import org.sentrysoftware.jawk.jrt.AssocArray;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.ConnectorVariables;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.common.HttpMethod;
import org.sentrysoftware.metricshub.engine.connector.model.common.ResultContent;
import org.sentrysoftware.metricshub.engine.connector.model.identity.ConnectorDefaultVariable;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.HttpSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpGetSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpTableSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WbemSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WmiSource;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsHubExtensionForJawk
extends AbstractExtension
implements JawkExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsHubExtensionForJawk.class);
    private SourceProcessor sourceProcessor;
    private String hostname;
    private String connectorId;

    @Override
    public String getExtensionName() {
        return "MetricsHubExtensionForJawk";
    }

    @Override
    public String[] extensionKeywords() {
        return new String[]{"executeHttpRequest", "executeIpmiRequest", "executeSnmpGet", "executeSnmpTable", "executeWbemRequest", "executeWmiRequest", "json2csv", "getVariable"};
    }

    @Override
    public int[] getAssocArrayParameterPositions(String extensionKeyword, int numArgs) {
        if (extensionKeyword.equals("executeIpmiRequest") || extensionKeyword.equals("executeSnmpGet") || extensionKeyword.equals("executeSnmpTable") || extensionKeyword.equals("executeWbemRequest") || extensionKeyword.equals("executeWmiRequest") || extensionKeyword.equals("executeHttpRequest") || extensionKeyword.equals("json2csv")) {
            return new int[]{0};
        }
        if (extensionKeyword.equals("getVariable")) {
            return new int[0];
        }
        throw new NotImplementedError(extensionKeyword);
    }

    @Override
    public Object invoke(String keyword, Object[] args) {
        if (keyword.equals("executeHttpRequest")) {
            MetricsHubExtensionForJawk.checkNumArgs(args, 1);
            return this.executeHttpRequest(args);
        }
        if (keyword.equals("executeIpmiRequest")) {
            MetricsHubExtensionForJawk.checkNumArgs(args, 1);
            return this.executeIpmiRequest(args);
        }
        if (keyword.equals("executeSnmpGet")) {
            MetricsHubExtensionForJawk.checkNumArgs(args, 1);
            return this.executeSnmpGetRequest(args);
        }
        if (keyword.equals("executeSnmpTable")) {
            MetricsHubExtensionForJawk.checkNumArgs(args, 1);
            return this.executeSnmpTableRequest(args);
        }
        if (keyword.equals("executeWbemRequest")) {
            MetricsHubExtensionForJawk.checkNumArgs(args, 1);
            return this.executeWbemRequest(args);
        }
        if (keyword.equals("executeWmiRequest")) {
            MetricsHubExtensionForJawk.checkNumArgs(args, 1);
            return this.executeWmiRequest(args);
        }
        if (keyword.equals("json2csv")) {
            MetricsHubExtensionForJawk.checkNumArgs(args, 1);
            return this.executeJson2csv(args);
        }
        if (keyword.equals("getVariable")) {
            MetricsHubExtensionForJawk.checkNumArgs(args, 1);
            return this.getVariable(args);
        }
        throw new NotImplementedError(keyword);
    }

    private String executeHttpRequest(Object[] args) {
        Object object = args[0];
        if (object instanceof AssocArray) {
            AssocArray argsAssocArray = (AssocArray)object;
            return this.executeSource((Source)HttpSource.builder().type("http").method(HttpMethod.valueOf((String)this.toAwkString(argsAssocArray.get("method")).toUpperCase())).path(this.toAwkString(argsAssocArray.get("path"))).header(this.toAwkString(argsAssocArray.get("header"))).body(this.toAwkString(argsAssocArray.get("body"))).authenticationToken(this.toAwkString(argsAssocArray.get("authenticationToken"))).resultContent(ResultContent.detect((String)this.toAwkString(argsAssocArray.get("resultContent")))).forceSerialization(this.toAwkString(argsAssocArray.get("forceSerialization")).equals("true")).build());
        }
        log.warn("Hostname {} - Awk: executeHttpRequest(): expected Association array.", (Object)this.hostname);
        return "";
    }

    private String executeIpmiRequest(Object[] args) {
        Object object = args[0];
        if (object instanceof AssocArray) {
            AssocArray argsAssocArray = (AssocArray)object;
            return this.executeSource((Source)IpmiSource.builder().type("ipmi").forceSerialization(this.toAwkString(argsAssocArray.get("forceSerialization")).equals("true")).build());
        }
        return this.executeSource((Source)IpmiSource.builder().forceSerialization(false).build());
    }

    private String executeSnmpGetRequest(Object[] args) {
        Object object = args[0];
        if (object instanceof AssocArray) {
            AssocArray argsAssocArray = (AssocArray)object;
            return this.executeSource((Source)SnmpGetSource.builder().type("snmpGet").oid(this.toAwkString(argsAssocArray.get("oid"))).forceSerialization(this.toAwkString(argsAssocArray.get("forceSerialization")).equals("true")).build());
        }
        log.warn("Hostname {} - Awk: executeSnmpGetRequest(): expected Association array.", (Object)this.hostname);
        return "";
    }

    private String executeSnmpTableRequest(Object[] args) {
        Object object = args[0];
        if (object instanceof AssocArray) {
            AssocArray argsAssocArray = (AssocArray)object;
            return this.executeSource((Source)SnmpTableSource.builder().type("snmpTable").oid(this.toAwkString(argsAssocArray.get("oid"))).selectColumns(this.toAwkString(argsAssocArray.get("selectColumns"))).forceSerialization(this.toAwkString(argsAssocArray.get("forceSerialization")).equals("true")).build());
        }
        log.warn("Hostname {} - Awk: executeSnmpTableRequest(): expected Association array.", (Object)this.hostname);
        return "";
    }

    private String executeWbemRequest(Object[] args) {
        Object object = args[0];
        if (object instanceof AssocArray) {
            AssocArray argsAssocArray = (AssocArray)object;
            return this.executeSource((Source)WbemSource.builder().type("wbem").query(this.toAwkString(argsAssocArray.get("query"))).namespace(this.toAwkString(argsAssocArray.get("namespace"))).forceSerialization(this.toAwkString(argsAssocArray.get("forceSerialization")).equals("true")).build());
        }
        log.warn("Hostname {} - Awk: executeWbemRequest(): expected Association array.", (Object)this.hostname);
        return "";
    }

    private String executeWmiRequest(Object[] args) {
        Object object = args[0];
        if (object instanceof AssocArray) {
            AssocArray argsAssocArray = (AssocArray)object;
            return this.executeSource((Source)WmiSource.builder().type("wmi").query(this.toAwkString(argsAssocArray.get("query"))).namespace(this.toAwkString(argsAssocArray.get("namespace"))).forceSerialization(this.toAwkString(argsAssocArray.get("forceSerialization")).equals("true")).build());
        }
        log.warn("Hostname {} - Awk: executeWmiRequest(): expected Association array.", (Object)this.hostname);
        return "";
    }

    private String executeSource(Source source) {
        SourceTable sourceTableResult = source.accept((ISourceProcessor)this.sourceProcessor);
        if (sourceTableResult != null && !sourceTableResult.isEmpty()) {
            return sourceTableResult.getRawData() != null ? sourceTableResult.getRawData() : SourceTable.tableToCsv((List)sourceTableResult.getTable(), (String)";", (boolean)false);
        }
        return "";
    }

    private String executeJson2csv(Object[] args) {
        Object object = args[0];
        if (object instanceof AssocArray) {
            AssocArray argsAssocArray = (AssocArray)object;
            try {
                return ClientsExecutor.executeJson2Csv((String)this.toAwkString(argsAssocArray.get("jsonSource")), (String)this.toAwkString(argsAssocArray.get("entryKey")), this.toAwkListString(argsAssocArray.get("properties")), (String)this.toAwkString(argsAssocArray.get("separator")), (String)this.hostname).strip();
            }
            catch (Exception exception) {
                log.error("Hostname {} - Json2Csv Operation has failed. Errors:\n{}\n", (Object)this.hostname, (Object)StringHelper.getStackMessages((Throwable)exception));
                return "";
            }
        }
        log.warn("Hostname {} - Awk: executeJson2csv(): expected Association array.", (Object)this.hostname);
        return "";
    }

    private List<String> toAwkListString(Object arg) {
        String stringArg = this.toAwkString(arg);
        return Arrays.asList(stringArg.split(";"));
    }

    private String getVariable(Object[] args) {
        String variableName = this.toAwkString(args[0]);
        ConnectorVariables connectorVariables = (ConnectorVariables)this.sourceProcessor.getTelemetryManager().getHostConfiguration().getConnectorVariables().get(this.connectorId);
        if (connectorVariables != null) {
            return (String)connectorVariables.getVariableValues().get(variableName);
        }
        return ((ConnectorDefaultVariable)((Connector)this.sourceProcessor.getTelemetryManager().getConnectorStore().getStore().get(this.connectorId)).getConnectorIdentity().getVariables().get(variableName)).getDefaultValue();
    }

    @Generated
    public static MetricsHubExtensionForJawkBuilder builder() {
        return new MetricsHubExtensionForJawkBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsHubExtensionForJawk)) {
            return false;
        }
        MetricsHubExtensionForJawk other = (MetricsHubExtensionForJawk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SourceProcessor this$sourceProcessor = this.sourceProcessor;
        SourceProcessor other$sourceProcessor = other.sourceProcessor;
        if (this$sourceProcessor == null ? other$sourceProcessor != null : !this$sourceProcessor.equals(other$sourceProcessor)) {
            return false;
        }
        String this$hostname = this.hostname;
        String other$hostname = other.hostname;
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$connectorId = this.connectorId;
        String other$connectorId = other.connectorId;
        return !(this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricsHubExtensionForJawk;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SourceProcessor $sourceProcessor = this.sourceProcessor;
        result = result * 59 + ($sourceProcessor == null ? 43 : $sourceProcessor.hashCode());
        String $hostname = this.hostname;
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $connectorId = this.connectorId;
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        return result;
    }

    @Generated
    public MetricsHubExtensionForJawk(SourceProcessor sourceProcessor, String hostname, String connectorId) {
        this.sourceProcessor = sourceProcessor;
        this.hostname = hostname;
        this.connectorId = connectorId;
    }

    @Generated
    public static class MetricsHubExtensionForJawkBuilder {
        @Generated
        private SourceProcessor sourceProcessor;
        @Generated
        private String hostname;
        @Generated
        private String connectorId;

        @Generated
        MetricsHubExtensionForJawkBuilder() {
        }

        @Generated
        public MetricsHubExtensionForJawkBuilder sourceProcessor(SourceProcessor sourceProcessor) {
            this.sourceProcessor = sourceProcessor;
            return this;
        }

        @Generated
        public MetricsHubExtensionForJawkBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public MetricsHubExtensionForJawkBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public MetricsHubExtensionForJawk build() {
            return new MetricsHubExtensionForJawk(this.sourceProcessor, this.hostname, this.connectorId);
        }

        @Generated
        public String toString() {
            return "MetricsHubExtensionForJawk.MetricsHubExtensionForJawkBuilder(sourceProcessor=" + String.valueOf(this.sourceProcessor) + ", hostname=" + this.hostname + ", connectorId=" + this.connectorId + ")";
        }
    }
}

