/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.wmi;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.deserialization.MultiValueDeserializer;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;

public class WmiConfiguration
implements IWinConfiguration {
    private String username;
    private char[] password;
    private String namespace;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    private String hostname;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private Long timeout;

    public String toString() {
        Object description = "WMI";
        if (this.username != null) {
            description = (String)description + " as " + this.username;
        }
        return description;
    }

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, "WMI", this.timeout));
    }

    public IConfiguration copy() {
        return WmiConfiguration.builder().namespace(this.namespace).password(this.password).timeout(this.timeout).username(this.username).hostname(this.hostname).build();
    }

    @Generated
    private static Long $default$timeout() {
        return 120L;
    }

    @Generated
    public static WmiConfigurationBuilder builder() {
        return new WmiConfigurationBuilder();
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WmiConfiguration)) {
            return false;
        }
        WmiConfiguration other = (WmiConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WmiConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    @Generated
    public WmiConfiguration(String username, char[] password, String namespace, String hostname, Long timeout) {
        this.username = username;
        this.password = password;
        this.namespace = namespace;
        this.hostname = hostname;
        this.timeout = timeout;
    }

    @Generated
    public WmiConfiguration() {
        this.timeout = WmiConfiguration.$default$timeout();
    }

    @Generated
    public static class WmiConfigurationBuilder {
        @Generated
        private String username;
        @Generated
        private char[] password;
        @Generated
        private String namespace;
        @Generated
        private String hostname;
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;

        @Generated
        WmiConfigurationBuilder() {
        }

        @Generated
        public WmiConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public WmiConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @Generated
        public WmiConfigurationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MultiValueDeserializer.class)
        @Generated
        public WmiConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public WmiConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public WmiConfiguration build() {
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = WmiConfiguration.$default$timeout();
            }
            return new WmiConfiguration(this.username, this.password, this.namespace, this.hostname, timeout$value);
        }

        @Generated
        public String toString() {
            return "WmiConfiguration.WmiConfigurationBuilder(username=" + this.username + ", password=" + Arrays.toString(this.password) + ", namespace=" + this.namespace + ", hostname=" + this.hostname + ", timeout$value=" + this.timeout$value + ")";
        }
    }
}

