/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final String EMPTY = "";
    public static final String NEW_LINE = "\n";
    public static final String DEFAULT_ARRAY_SEPARATOR = "|";
    public static final String DEFAULT_COLUMN_SEPARATOR = ";";
    public static final String STATUS_SUCCESS = "SUCCESS";
    public static final String STATUS_ERROR = "ERROR";
    private static final Pattern CIM_DATETIME_PATTERN = Pattern.compile("^([0-9]{14})(?:\\.([0-9]{3,6}))?([+-][0-9]{3})$");
    public static final DateTimeFormatter WBEM_CIM_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    private Utils() {
    }

    public static <T> void checkNonNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " must not be null.");
        }
    }

    public static void checkNonBlank(String argument, String name) {
        if (Utils.isBlank(argument)) {
            throw new IllegalArgumentException(name + " must not be null or empty.");
        }
    }

    public static void checkArgumentNotZeroOrNegative(long argument, String name) {
        if (argument <= 0L) {
            throw new IllegalArgumentException(String.format("%s=%d must not be negative or zero.", name, argument));
        }
    }

    public static <T> void checkNonNullField(T field, String name) {
        if (field == null) {
            throw new IllegalStateException(name + " must not be null.");
        }
    }

    public static OffsetDateTime convertCimDateTime(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        Matcher dateTimeMatcher = CIM_DATETIME_PATTERN.matcher(stringValue);
        if (!dateTimeMatcher.find()) {
            throw new IllegalArgumentException("Not a valid CIM_DATETIME value: " + stringValue);
        }
        LocalDateTime localDateTime = LocalDateTime.parse(dateTimeMatcher.group(1), WBEM_CIM_DATETIME_FORMATTER);
        String zoneOffset = dateTimeMatcher.group(3);
        if (zoneOffset == null) {
            throw new IllegalStateException("Unable to get the timezone offset from CIM_DATETIME value: " + stringValue);
        }
        int secondsOffset = Integer.parseInt(zoneOffset) * 60;
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(secondsOffset);
        return OffsetDateTime.of(localDateTime, offset);
    }

    public static String getComputerName() {
        String computerName = System.getenv("COMPUTERNAME");
        if (computerName == null) {
            return "localhost";
        }
        return computerName;
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static boolean isBlank(String value) {
        return value == null || Utils.isEmpty(value);
    }

    public static boolean isNotBlank(String value) {
        return !Utils.isBlank(value);
    }

    public static boolean isEmpty(String value) {
        return value.trim().isEmpty();
    }

    public static String readText(Path filePath, Charset charset) {
        Utils.checkNonNull(filePath, "filePath");
        Utils.checkNonNull(charset, "charset");
        if (!Files.isRegularFile(filePath, new LinkOption[0]) || !Files.isReadable(filePath)) {
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = Files.newBufferedReader(filePath, charset);){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line).append(NEW_LINE);
            }
        }
        catch (IOException e) {
            return EMPTY;
        }
        return result.toString();
    }

    public static void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }
}

