/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WmiStringConverter {
    protected static final String TRUE_STRING = "True";
    protected static final String FALSE_STRING = "False";
    private static final DateTimeFormatter CSV_US_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EE MMM dd HH:mm:ss yyyy", Locale.US);
    private String arraySeparator;
    private boolean epoch;

    public WmiStringConverter(String arraySeparator, boolean useEpoch) {
        this.arraySeparator = arraySeparator;
        this.epoch = useEpoch;
    }

    public WmiStringConverter() {
        this("|", true);
    }

    public String convert(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            return Stream.of((Object[])value).map(this::convert).map(item -> item.replace(this.arraySeparator, "")).collect(Collectors.joining(this.arraySeparator, "", this.arraySeparator));
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? TRUE_STRING : FALSE_STRING;
        }
        if (value instanceof OffsetDateTime) {
            return this.epoch ? String.valueOf(((OffsetDateTime)value).toEpochSecond()) : ((OffsetDateTime)value).format(CSV_US_DATE_TIME_FORMATTER);
        }
        return String.valueOf(value);
    }
}

