/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi.wbem;

import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinNT;
import org.sentrysoftware.wmi.exceptions.WmiComException;

public class WmiComHelper {
    private static ThreadLocal<Boolean> comLibraryInitialized = ThreadLocal.withInitial(() -> false);

    private WmiComHelper() {
    }

    public static void initializeComLibrary() throws WmiComException {
        if (Boolean.TRUE.equals(comLibraryInitialized.get())) {
            return;
        }
        WinNT.HRESULT hCoInitResult = Ole32.INSTANCE.CoInitializeEx(null, 0);
        int coInitResult = hCoInitResult.intValue();
        if (coInitResult == -2147417850) {
            throw new IllegalStateException("CoInitializeEx() has already been called with a different threading model");
        }
        if (coInitResult != 0 && coInitResult != 1) {
            throw new WmiComException("Failed to initialize the COM Library (HRESULT=0x%s)", Integer.toHexString(coInitResult));
        }
        WinNT.HRESULT hResult = Ole32.INSTANCE.CoInitializeSecurity(null, -1, null, null, 0, 3, null, 0, null);
        if (COMUtils.FAILED(hResult) && hResult.intValue() != -2147417831) {
            WmiComHelper.unInitializeCom();
            throw new WmiComException("Failed to initialize security (HRESULT=0x%s)", Integer.toHexString(hResult.intValue()));
        }
        comLibraryInitialized.set(true);
    }

    public static void unInitializeCom() {
        if (Boolean.FALSE.equals(comLibraryInitialized.get())) {
            return;
        }
        Ole32.INSTANCE.CoUninitialize();
        comLibraryInitialized.set(false);
    }

    public static boolean isComInitialized() {
        return comLibraryInitialized.get();
    }

    public static Object comInvokerInvokeNativeObject(Pointer contextPointer, int vtableId, Object[] args, Class<?> returnType) {
        Pointer vptr = contextPointer.getPointer(0L);
        Function func = Function.getFunction(vptr.getPointer((long)(vtableId * Native.POINTER_SIZE) * 1L));
        return func.invoke(returnType, args);
    }
}

