/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.sentrysoftware.http.HttpResponse;
import org.sentrysoftware.http.ProtocolOverridingSSLSocketFactory;
import org.sentrysoftware.http.ThreadSafeNoCacheAuthenticator;

public class HttpClient {
    public static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393 org.sentrysoftware.http";
    private static final int MAX_CONTENT_LENGTH = 0x3200000;
    private static final int BUFFER_SIZE = 65536;
    private static final Charset UTF8_CHARSET;
    private static final Pattern CHARSET_REGEX;
    private static final HostnameVerifier LOUSY_HOSTNAME_VERIFIER;
    private static final TrustManager[] LOUSY_TRUST_MANAGER;
    private static final SSLSocketFactory BASE_SOCKET_FACTORY;
    private static final String[] DEFAULT_SSL_PROTOCOLS;

    private static InputStream getDecodedStream(HttpURLConnection httpURL) {
        String contentEncoding = httpURL.getContentEncoding();
        try {
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                return new GZIPInputStream(httpURL.getInputStream());
            }
            if ("deflate".equalsIgnoreCase(contentEncoding)) {
                return new InflaterInputStream(httpURL.getInputStream());
            }
            return httpURL.getInputStream();
        }
        catch (IOException e) {
            return httpURL.getErrorStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse sendRequest(String url, String method, String[] specifiedSslProtocolArray, String username, char[] password, String proxyServer, int proxyPort, String proxyUsername, char[] proxyPassword, String userAgent, Map<String, String> addHeaderMap, String body, int timeout, String downloadToPath) throws IOException {
        File parentDirectory;
        HttpURLConnection httpURL;
        boolean useProxy;
        boolean bl = useProxy = proxyServer != null && !proxyServer.isEmpty();
        if (!useProxy) {
            httpURL = (HttpURLConnection)new URL(url).openConnection();
        } else {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyServer, proxyPort));
            httpURL = (HttpURLConnection)new URL(url).openConnection(proxy);
        }
        File downloadToFile = null;
        if (downloadToPath != null && !downloadToPath.isEmpty() && (parentDirectory = (downloadToFile = new File(downloadToPath)).getParentFile()) != null && !parentDirectory.exists()) {
            try {
                parentDirectory.mkdirs();
            }
            catch (SecurityException e) {
                throw new IOException("Couldn't create the necessary directories for " + downloadToPath);
            }
        }
        if (httpURL instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURL).setHostnameVerifier(LOUSY_HOSTNAME_VERIFIER);
            if (specifiedSslProtocolArray == null || specifiedSslProtocolArray.length == 0) {
                ((HttpsURLConnection)httpURL).setSSLSocketFactory(BASE_SOCKET_FACTORY);
            } else {
                String[] protocolsToEnable = (String[])Arrays.stream(specifiedSslProtocolArray).filter(p -> p != null && !"SSLv2Hello".equalsIgnoreCase((String)p)).filter(p -> Arrays.stream(DEFAULT_SSL_PROTOCOLS).anyMatch(d -> d.equalsIgnoreCase((String)p))).toArray(String[]::new);
                ProtocolOverridingSSLSocketFactory overridenSocketFactory = new ProtocolOverridingSSLSocketFactory(BASE_SOCKET_FACTORY, protocolsToEnable);
                ((HttpsURLConnection)httpURL).setSSLSocketFactory(overridenSocketFactory);
            }
        }
        httpURL.setRequestMethod(method);
        httpURL.setDefaultUseCaches(false);
        httpURL.setDoOutput(true);
        httpURL.setDoInput(true);
        httpURL.setConnectTimeout(timeout * 1000);
        httpURL.setReadTimeout(timeout * 1000);
        httpURL.setAllowUserInteraction(false);
        httpURL.setInstanceFollowRedirects(true);
        if (userAgent == null || userAgent.isEmpty()) {
            userAgent = DEFAULT_USER_AGENT;
        }
        httpURL.addRequestProperty("User-Agent", userAgent);
        if (addHeaderMap != null) {
            addHeaderMap.forEach((header, value) -> {
                if (header != null && value != null && !header.isEmpty() && !value.isEmpty()) {
                    httpURL.addRequestProperty((String)header, (String)value);
                }
            });
        }
        ThreadSafeNoCacheAuthenticator.setCredentials(username, password, proxyUsername, proxyPassword);
        Authenticator.setDefault(ThreadSafeNoCacheAuthenticator.getInstance());
        try {
            Matcher charsetMatcher;
            httpURL.connect();
            if (body != null && !body.isEmpty()) {
                try (OutputStream os = httpURL.getOutputStream();){
                    os.write(body.getBytes(UTF8_CHARSET));
                }
            }
            HttpResponse response = new HttpResponse();
            response.setStatusCode(httpURL.getResponseCode());
            httpURL.getHeaderFields().forEach((header, valueList) -> valueList.forEach(value -> response.appendHeader((String)header, (String)value)));
            if (downloadToFile != null) {
                if (downloadToFile.isDirectory()) {
                    String tempFilename = httpURL.getURL().getPath();
                    String filename = tempFilename.substring(tempFilename.lastIndexOf(47));
                    downloadToPath = new File(downloadToFile, filename).getPath();
                }
                try (Object fileStream = new FileOutputStream(downloadToPath);
                     InputStream httpStream = HttpClient.getDecodedStream(httpURL);){
                    int readBytes;
                    byte[] tempBuf = new byte[65536];
                    while ((readBytes = httpStream.read(tempBuf)) != -1) {
                        ((FileOutputStream)fileStream).write(tempBuf, 0, readBytes);
                    }
                }
                response.appendBody(downloadToPath);
                fileStream = response;
                return fileStream;
            }
            int contentLength = httpURL.getContentLength();
            if (contentLength > 0x3200000) {
                throw new IOException("Content is too large (" + contentLength + " bytes > " + 0x3200000 + " bytes)");
            }
            Charset charset = UTF8_CHARSET;
            String contentType = httpURL.getContentType();
            if (contentType != null && (charsetMatcher = CHARSET_REGEX.matcher(contentType)).find()) {
                charset = Charset.forName(charsetMatcher.group(1));
            }
            ByteArrayOutputStream bodyBytes = contentLength > 0 ? new ByteArrayOutputStream(contentLength) : new ByteArrayOutputStream();
            byte[] buffer = new byte[65536];
            int totalBytesCount = 0;
            try (InputStream httpStream = HttpClient.getDecodedStream(httpURL);){
                int bytesCount;
                while (httpStream != null && (bytesCount = httpStream.read(buffer)) != -1) {
                    bodyBytes.write(buffer, 0, bytesCount);
                    if ((totalBytesCount += bytesCount) <= 0x3200000) continue;
                    throw new IOException("Content is too large (maximum 52428800 bytes)");
                }
            }
            response.appendBody(new String(bodyBytes.toByteArray(), charset));
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            httpURL.disconnect();
            ThreadSafeNoCacheAuthenticator.clearCredentials();
        }
    }

    static {
        System.setProperty("jdk.tls.acknowledgeCloseNotify", "true");
        UTF8_CHARSET = StandardCharsets.UTF_8;
        CHARSET_REGEX = Pattern.compile("charset=\\s*\"?([^; \"]+)", 2);
        LOUSY_HOSTNAME_VERIFIER = (urlHostName, session) -> true;
        LOUSY_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, LOUSY_TRUST_MANAGER, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        BASE_SOCKET_FACTORY = sc.getSocketFactory();
        DEFAULT_SSL_PROTOCOLS = sc.getDefaultSSLParameters().getProtocols();
    }
}

