/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.http;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.ConcurrentHashMap;
import sun.net.www.protocol.http.AuthCache;
import sun.net.www.protocol.http.AuthCacheValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ThreadSafeNoCacheAuthenticator
extends Authenticator {
    private static ThreadSafeNoCacheAuthenticator oneSingleAuthenticator = new ThreadSafeNoCacheAuthenticator();
    private static ConcurrentHashMap<Thread, CredEntry> credList = new ConcurrentHashMap();

    private ThreadSafeNoCacheAuthenticator() {
    }

    public static ThreadSafeNoCacheAuthenticator getInstance() {
        return oneSingleAuthenticator;
    }

    public static void setCredentials(String pUsername, char[] pPassword, String pProxyUsername, char[] pProxyPassword) {
        credList.put(Thread.currentThread(), new CredEntry(pUsername, pPassword, pProxyUsername, pProxyPassword));
    }

    public static void setCredentials(String pUsername, char[] pPassword) {
        credList.put(Thread.currentThread(), new CredEntry(pUsername, pPassword, null, null));
    }

    public static void clearCredentials() {
        credList.remove(Thread.currentThread());
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        CredEntry credEntry = credList.get(Thread.currentThread());
        if (credEntry == null) {
            return null;
        }
        if (this.getRequestorType() == Authenticator.RequestorType.SERVER && credEntry.username != null && credEntry.password != null) {
            return new PasswordAuthentication(credEntry.username, credEntry.password);
        }
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && credEntry.proxyUsername != null && credEntry.proxyPassword != null) {
            return new PasswordAuthentication(credEntry.proxyUsername, credEntry.proxyPassword);
        }
        return null;
    }

    static {
        AuthCacheValue.setAuthCache((AuthCache)new DisabledCache());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CredEntry {
        public String username;
        public char[] password;
        public String proxyUsername;
        public char[] proxyPassword;

        public CredEntry(String pUsername, char[] pPassword, String pProxyUsername, char[] pProxyPassword) {
            this.username = pUsername;
            this.password = pPassword;
            this.proxyUsername = pProxyUsername;
            this.proxyPassword = pProxyPassword;
        }
    }

    static class DisabledCache
    implements AuthCache {
        DisabledCache() {
        }

        @Override
        public void put(String pkey, AuthCacheValue value) {
        }

        @Override
        public AuthCacheValue get(String pkey, String skey) {
            return null;
        }

        @Override
        public void remove(String pkey, AuthCacheValue entry) {
        }
    }
}

