/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.http;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.deserialization.MultiValueDeserializer;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class HttpConfiguration
implements IConfiguration {
    @JsonSetter(nulls=Nulls.SKIP)
    private final Boolean https;
    @JsonSetter(nulls=Nulls.SKIP)
    private final Integer port;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private final Long timeout;
    private String username;
    private char[] password;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    private String hostname;

    public String toString() {
        return String.format("%s/%d%s", Boolean.TRUE.equals(this.https) ? "HTTPS" : "HTTP", this.port, this.username != null ? " as " + this.username : "");
    }

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, "HTTP", this.timeout));
        StringHelper.validateConfigurationAttribute((Object)this.port, attr -> attr == null || attr < 1 || attr > 65535, () -> String.format("Resource %s - Invalid port configured for protocol %s. Port value returned: %s. This resource will not be monitored. Please verify the configured port value.", resourceKey, "HTTP", this.port));
    }

    public IConfiguration copy() {
        return HttpConfiguration.builder().username(this.username).password(this.password).https(this.https).port(this.port).timeout(this.timeout).hostname(this.hostname).build();
    }

    @Generated
    private static Boolean $default$https() {
        return true;
    }

    @Generated
    private static Integer $default$port() {
        return 443;
    }

    @Generated
    private static Long $default$timeout() {
        return 120L;
    }

    @Generated
    public static HttpConfigurationBuilder builder() {
        return new HttpConfigurationBuilder();
    }

    @Generated
    public Boolean getHttps() {
        return this.https;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpConfiguration)) {
            return false;
        }
        HttpConfiguration other = (HttpConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$https = this.getHttps();
        Boolean other$https = other.getHttps();
        if (this$https == null ? other$https != null : !((Object)this$https).equals(other$https)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $https = this.getHttps();
        result = result * 59 + ($https == null ? 43 : ((Object)$https).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    @Generated
    public HttpConfiguration(Boolean https, Integer port, Long timeout, String username, char[] password, String hostname) {
        this.https = https;
        this.port = port;
        this.timeout = timeout;
        this.username = username;
        this.password = password;
        this.hostname = hostname;
    }

    @Generated
    public HttpConfiguration() {
        this.https = HttpConfiguration.$default$https();
        this.port = HttpConfiguration.$default$port();
        this.timeout = HttpConfiguration.$default$timeout();
    }

    @Generated
    public static class HttpConfigurationBuilder {
        @Generated
        private boolean https$set;
        @Generated
        private Boolean https$value;
        @Generated
        private boolean port$set;
        @Generated
        private Integer port$value;
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;
        @Generated
        private String username;
        @Generated
        private char[] password;
        @Generated
        private String hostname;

        @Generated
        HttpConfigurationBuilder() {
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public HttpConfigurationBuilder https(Boolean https) {
            this.https$value = https;
            this.https$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public HttpConfigurationBuilder port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public HttpConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MultiValueDeserializer.class)
        @Generated
        public HttpConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public HttpConfiguration build() {
            Boolean https$value = this.https$value;
            if (!this.https$set) {
                https$value = HttpConfiguration.$default$https();
            }
            Integer port$value = this.port$value;
            if (!this.port$set) {
                port$value = HttpConfiguration.$default$port();
            }
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = HttpConfiguration.$default$timeout();
            }
            return new HttpConfiguration(https$value, port$value, timeout$value, this.username, this.password, this.hostname);
        }

        @Generated
        public String toString() {
            return "HttpConfiguration.HttpConfigurationBuilder(https$value=" + this.https$value + ", port$value=" + this.port$value + ", timeout$value=" + this.timeout$value + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", hostname=" + this.hostname + ")";
        }
    }
}

