/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.http;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.HttpCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.http.HttpConfiguration;
import org.sentrysoftware.metricshub.extension.http.HttpRequestExecutor;
import org.sentrysoftware.metricshub.extension.http.utils.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpCriterionProcessor.class);
    private HttpRequestExecutor httpRequestExecutor;
    private static final String HTTP_TEST_SUCCESS = "Hostname %s - HTTP test succeeded. Returned result: %s.";

    public CriterionTestResult process(HttpCriterion httpCriterion, String connectorId, TelemetryManager telemetryManager) {
        HostConfiguration hostConfiguration = telemetryManager.getHostConfiguration();
        if (hostConfiguration == null) {
            log.debug("There is no host configuration. Cannot process HTTP detection {}.", (Object)httpCriterion);
            return CriterionTestResult.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(HttpConfiguration.class));
        if (httpCriterion == null) {
            log.error("Hostname {} - Malformed SNMP Get criterion {}. Cannot process SNMP Get detection. Connector ID: {}.", new Object[]{hostname, httpCriterion, connectorId});
            return CriterionTestResult.empty();
        }
        HttpConfiguration httpConfiguration = (HttpConfiguration)hostConfiguration.getConfigurations().get(HttpConfiguration.class);
        if (httpConfiguration == null) {
            log.debug("Hostname {} - The HTTP credentials are not configured for this host. Cannot process HTTP detection {}.", (Object)hostname, (Object)httpCriterion);
            return CriterionTestResult.empty();
        }
        Map connectorEmbeddedFiles = telemetryManager.getEmbeddedFiles(connectorId);
        try {
            String result = this.httpRequestExecutor.executeHttp(HttpRequest.builder().hostname(hostname).method(httpCriterion.getMethod().toString()).url(httpCriterion.getUrl()).path(httpCriterion.getPath()).header(httpCriterion.getHeader(), connectorEmbeddedFiles, connectorId, hostname).body(httpCriterion.getBody(), connectorEmbeddedFiles, connectorId, hostname).httpConfiguration(httpConfiguration).resultContent(httpCriterion.getResultContent()).authenticationToken(httpCriterion.getAuthenticationToken()).build(), false, telemetryManager);
            return this.checkHttpResult(hostname, result, httpCriterion.getExpectedResult());
        }
        catch (Exception e) {
            return CriterionTestResult.error((Criterion)httpCriterion, (Throwable)e);
        }
    }

    private CriterionTestResult checkHttpResult(String hostname, String result, String expectedResult) {
        Object message;
        boolean success = false;
        if (expectedResult == null) {
            if (result == null || result.isEmpty()) {
                message = String.format("Hostname %s - HTTP test failed - The HTTP test did not return any result.", hostname);
            } else {
                message = String.format(HTTP_TEST_SUCCESS, hostname, result);
                success = true;
            }
        } else {
            Pattern pattern = Pattern.compile(PslUtils.psl2JavaRegex((String)expectedResult), 2);
            if (result != null && pattern.matcher(result).find()) {
                message = String.format(HTTP_TEST_SUCCESS, hostname, result);
                success = true;
            } else {
                message = String.format("Hostname %s - HTTP test failed - The result (%s) returned by the HTTP test did not match the expected result (%s).", hostname, result, expectedResult);
                message = (String)message + String.format("Expected value: %s - returned value %s.", expectedResult, result);
            }
        }
        log.debug((String)message);
        return CriterionTestResult.builder().result(result).message((String)message).success(success).build();
    }

    @Generated
    public HttpCriterionProcessor(HttpRequestExecutor httpRequestExecutor) {
        this.httpRequestExecutor = httpRequestExecutor;
    }
}

