/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.http;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.ResultContent;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.HttpCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.HttpSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.http.HttpConfiguration;
import org.sentrysoftware.metricshub.extension.http.HttpCriterionProcessor;
import org.sentrysoftware.metricshub.extension.http.HttpRequestExecutor;
import org.sentrysoftware.metricshub.extension.http.HttpSourceProcessor;
import org.sentrysoftware.metricshub.extension.http.utils.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExtension
implements IProtocolExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpExtension.class);
    private static final String IDENTIFIER = "http";
    private HttpRequestExecutor httpRequestExecutor = new HttpRequestExecutor();

    public boolean isValidConfiguration(IConfiguration configuration) {
        return configuration instanceof HttpConfiguration;
    }

    public Set<Class<? extends Source>> getSupportedSources() {
        return Set.of(HttpSource.class);
    }

    public Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> getConfigurationToSourceMapping() {
        return Map.of(HttpConfiguration.class, Set.of(HttpSource.class));
    }

    public Set<Class<? extends Criterion>> getSupportedCriteria() {
        return Set.of(HttpCriterion.class);
    }

    public Optional<Boolean> checkProtocol(TelemetryManager telemetryManager) {
        HttpConfiguration httpConfiguration = (HttpConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(HttpConfiguration.class);
        if (httpConfiguration == null) {
            return Optional.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(HttpConfiguration.class));
        String httpResult = null;
        log.info("Hostname {} - Performing {} protocol health check.", (Object)hostname, (Object)this.getIdentifier());
        log.info("Hostname {} - Checking HTTP protocol status. Sending GET request to '/'.", (Object)hostname);
        try {
            HttpRequest request = HttpRequest.builder().hostname(hostname).path("/").httpConfiguration(httpConfiguration).resultContent(ResultContent.ALL).build();
            httpResult = this.httpRequestExecutor.executeHttp(request, true, telemetryManager);
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking HTTP protocol status. HTTP exception when performing a GET request to '/': ", (Object)hostname, (Object)e);
        }
        return Optional.of(httpResult != null);
    }

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager) {
        if (source instanceof HttpSource) {
            HttpSource httpSource = (HttpSource)source;
            return new HttpSourceProcessor(this.httpRequestExecutor).process(httpSource, connectorId, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process source %s.", telemetryManager.getHostname(), source != null ? source.getClass().getSimpleName() : "<null>"));
    }

    public CriterionTestResult processCriterion(Criterion criterion, String connectorId, TelemetryManager telemetryManager) {
        if (criterion instanceof HttpCriterion) {
            HttpCriterion httpCriterion = (HttpCriterion)criterion;
            return new HttpCriterionProcessor(this.httpRequestExecutor).process(httpCriterion, connectorId, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process criterion %s.", telemetryManager.getHostname(), criterion != null ? criterion.getClass().getSimpleName() : "<null>"));
    }

    public boolean isSupportedConfigurationType(String configurationType) {
        return IDENTIFIER.equalsIgnoreCase(configurationType);
    }

    public IConfiguration buildConfiguration(String configurationType, JsonNode jsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        try {
            char[] password;
            HttpConfiguration httpConfiguration = (HttpConfiguration)HttpExtension.newObjectMapper().treeToValue((TreeNode)jsonNode, HttpConfiguration.class);
            if (decrypt != null && (password = httpConfiguration.getPassword()) != null) {
                httpConfiguration.setPassword((char[])decrypt.apply(password));
            }
            return httpConfiguration;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error while reading HTTP Configuration. Error: %s", e.getMessage());
            log.error(errorMessage);
            log.debug("Error while reading HTTP Configuration. Stack trace:", (Throwable)e);
            throw new InvalidConfigurationException(errorMessage, (Throwable)e);
        }
    }

    public static JsonMapper newObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String executeQuery(IConfiguration configuration, JsonNode query) {
        String hostname = configuration.getHostname();
        String method = query.get("method").asText();
        JsonNode url = query.get("url");
        JsonNode header = query.get("header");
        JsonNode body = query.get("body");
        JsonNode resultContent = query.get("resultContent");
        HostConfiguration hostConfiguration = HostConfiguration.builder().configurations(Map.of(HttpConfiguration.class, configuration)).build();
        TelemetryManager telemetryManager = TelemetryManager.builder().hostConfiguration(hostConfiguration).build();
        HttpRequest httpRequest = HttpRequest.builder().hostname(hostname).httpConfiguration((HttpConfiguration)configuration).method(method).url(JsonHelper.isNotNull((JsonNode)url) ? url.asText() : null).header(JsonHelper.isNotNull((JsonNode)header) ? header.asText() : null, Map.of(), "", hostname).body(JsonHelper.isNotNull((JsonNode)body) ? body.asText() : null, Map.of(), "", hostname).resultContent(JsonHelper.isNotNull((JsonNode)resultContent) ? ResultContent.detect((String)resultContent.asText()) : ResultContent.ALL_WITH_STATUS).build();
        return this.httpRequestExecutor.executeHttp(httpRequest, false, telemetryManager);
    }
}

