/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.http;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.http.HttpClient;
import org.sentrysoftware.http.HttpResponse;
import org.sentrysoftware.metricshub.engine.common.exception.RetryableException;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.MacrosUpdater;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.model.common.ResultContent;
import org.sentrysoftware.metricshub.engine.strategy.utils.RetryOperation;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.http.HttpConfiguration;
import org.sentrysoftware.metricshub.extension.http.utils.Body;
import org.sentrysoftware.metricshub.extension.http.utils.Header;
import org.sentrysoftware.metricshub.extension.http.utils.HttpRequest;
import org.sentrysoftware.metricshub.extension.http.utils.UrlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HttpRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestExecutor.class);
    private static final String MASK = "*****";
    private static final char[] CHAR_ARRAY_MASK = "*****".toCharArray();
    private static final String HOSTNAME_CANNOT_BE_NULL = "hostname cannot be null";
    private static final String PROTOCOL_CANNOT_BE_NULL = "protocol cannot be null";

    @WithSpan(value="HTTP")
    public String executeHttp(@SpanAttribute(value="http.config") @NonNull HttpRequest httpRequest, boolean logMode, TelemetryManager telemetryManager) {
        if (httpRequest == null) {
            throw new IllegalArgumentException("httpRequest is marked non-null but is null");
        }
        HttpConfiguration httpConfiguration = httpRequest.getHttpConfiguration();
        Assert.notNull((Object)httpConfiguration, (String)PROTOCOL_CANNOT_BE_NULL);
        String hostname = httpRequest.getHostname();
        Assert.notNull((Object)hostname, (String)HOSTNAME_CANNOT_BE_NULL);
        String requestMethod = httpRequest.getMethod();
        String method = requestMethod != null ? requestMethod : "GET";
        String username = httpConfiguration.getUsername();
        char[] password = httpConfiguration.getPassword();
        String httpRequestAuthToken = httpRequest.getAuthenticationToken();
        String authenticationToken = MacrosUpdater.update((String)httpRequestAuthToken, (String)username, (char[])password, (String)httpRequestAuthToken, (String)hostname, (boolean)false);
        Header header = httpRequest.getHeader();
        Map headerContent = header == null ? Collections.emptyMap() : header.getContent(username, password, authenticationToken, hostname);
        Map headerContentProtected = header == null ? Collections.emptyMap() : header.getContent(username, CHAR_ARRAY_MASK, MASK, hostname);
        Body body = httpRequest.getBody();
        String bodyContent = body == null ? "" : body.getContent(username, password, authenticationToken, hostname);
        String bodyContentProtected = body == null ? "" : body.getContent(username, CHAR_ARRAY_MASK, MASK, hostname);
        String protocol = Boolean.TRUE.equals(httpConfiguration.getHttps()) ? "https" : "http";
        String httpRequestUrl = httpRequest.getUrl();
        String httpRequestPath = httpRequest.getPath();
        String path = MacrosUpdater.update((String)httpRequestPath, (String)username, (char[])password, (String)authenticationToken, (String)hostname, (boolean)false);
        String url = MacrosUpdater.update((String)httpRequestUrl, (String)username, (char[])password, (String)authenticationToken, (String)hostname, (boolean)false);
        String fullUrl = UrlHelper.format(protocol, hostname, httpConfiguration.getPort(), path, url);
        LoggingHelper.trace(() -> log.trace("Executing HTTP request: {} {}\n- hostname: {}\n- url: {}\n- path: {}\n- Protocol: {}\n- Port: {}\n- Request-headers:\n{}\n- Request-body:\n{}\n- Timeout: {} s\n- Get-result-content: {}\n", new Object[]{method, fullUrl, hostname, url, path, protocol, httpConfiguration.getPort(), StringHelper.prettyHttpHeaders((Map)headerContentProtected), bodyContentProtected, httpConfiguration.getTimeout().intValue(), httpRequest.getResultContent()}));
        return (String)RetryOperation.builder().withDescription(String.format("%s %s", method, fullUrl)).withWaitStrategy((long)((int)telemetryManager.getHostConfiguration().getRetryDelay())).withMaxRetries(1).withHostname(hostname).withDefaultValue((Object)"").build().run(() -> this.doHttpRequest(httpRequest.getResultContent(), logMode, httpConfiguration, hostname, method, username, password, headerContent, headerContentProtected, bodyContent, bodyContentProtected, url, path, protocol, fullUrl));
    }

    private String doHttpRequest(ResultContent resultContent, boolean logMode, HttpConfiguration httpConfiguration, String hostname, String method, String username, char[] password, Map<String, String> headerContent, Map<String, String> headerContentProtected, String bodyContent, String bodyContentProtected, String url, String path, String protocol, String fullUrl) {
        try {
            long startTime = System.currentTimeMillis();
            HttpResponse httpResponse = this.sendHttpRequest(fullUrl, method, username, password, headerContent, bodyContent, httpConfiguration.getTimeout().intValue());
            long responseTime = System.currentTimeMillis() - startTime;
            int statusCode = httpResponse.getStatusCode();
            if (statusCode >= 400) {
                log.warn("Hostname {} - Bad response for HTTP request {} {}: {}.", new Object[]{hostname, method, fullUrl, statusCode});
                if (statusCode == 500 || statusCode == 503 || statusCode == 504 || statusCode == 507) {
                    throw new RetryableException();
                }
                return "";
            }
            String result = switch (resultContent) {
                case ResultContent.BODY -> httpResponse.getBody();
                case ResultContent.HEADER -> httpResponse.getHeader();
                case ResultContent.HTTP_STATUS -> String.valueOf(statusCode);
                case ResultContent.ALL -> httpResponse.toString();
                case ResultContent.ALL_WITH_STATUS -> "Status: %s\n%s".formatted(statusCode, httpResponse.toString());
                default -> throw new IllegalArgumentException("Unsupported ResultContent: " + String.valueOf(resultContent));
            };
            LoggingHelper.trace(() -> log.trace("Executed HTTP request: {} {}\n- Hostname: {}\n- Url: {}\n- Path: {}\n- Protocol: {}\n- Port: {}\n- Request-headers:\n{}\n- Request-body:\n{}\n- Timeout: {} s\n- get-result-content: {}\n- response-status: {}\n- response-headers:\n{}\n- response-body:\n{}\n- response-time: {}\n", new Object[]{method, fullUrl, hostname, url, path, protocol, httpConfiguration.getPort(), StringHelper.prettyHttpHeaders((Map)headerContentProtected), bodyContentProtected, httpConfiguration.getTimeout().intValue(), resultContent, statusCode, httpResponse.getHeader(), httpResponse.getBody(), responseTime}));
            return result;
        }
        catch (IOException e) {
            if (logMode) {
                log.error("Hostname {} - Error detected when running HTTP request {} {}: {}\nReturning null.", new Object[]{hostname, method, fullUrl, e.getMessage()});
                log.debug("Hostname {} - Exception detected when running HTTP request {} {}:", new Object[]{hostname, method, fullUrl, e});
            }
            return null;
        }
    }

    private HttpResponse sendHttpRequest(String url, String method, String username, char[] password, Map<String, String> headerContent, String bodyContent, int timeout) throws IOException {
        return HttpClient.sendRequest(url, method, null, username, password, null, 0, null, null, null, headerContent, bodyContent, timeout, null);
    }
}

