/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.http;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.HttpSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.http.HttpConfiguration;
import org.sentrysoftware.metricshub.extension.http.HttpRequestExecutor;
import org.sentrysoftware.metricshub.extension.http.utils.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpSourceProcessor.class);
    private HttpRequestExecutor httpRequestExecutor;

    public SourceTable process(HttpSource httpSource, String connectorId, TelemetryManager telemetryManager) {
        HttpConfiguration httpConfiguration = (HttpConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(HttpConfiguration.class);
        if (httpConfiguration == null) {
            log.debug("Hostname {} - The HTTP credentials are not configured. Returning an empty table for HttpSource {}.", (Object)telemetryManager.getHostname(), (Object)httpSource);
            return SourceTable.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(HttpConfiguration.class));
        Map connectorEmbeddedFiles = telemetryManager.getEmbeddedFiles(connectorId);
        try {
            String result = this.httpRequestExecutor.executeHttp(HttpRequest.builder().hostname(hostname).method(httpSource.getMethod().toString()).url(httpSource.getUrl()).path(httpSource.getPath()).header(httpSource.getHeader(), connectorEmbeddedFiles, connectorId, hostname).body(httpSource.getBody(), connectorEmbeddedFiles, connectorId, hostname).resultContent(httpSource.getResultContent()).authenticationToken(httpSource.getAuthenticationToken()).httpConfiguration(httpConfiguration).build(), true, telemetryManager);
            if (result != null && !result.isEmpty()) {
                return SourceTable.builder().rawData(result).build();
            }
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)connectorId, (String)httpSource.getKey(), (String)String.format("HTTP %s %s", httpSource.getMethod(), httpSource.getUrl()), (String)hostname, (Throwable)e);
        }
        return SourceTable.empty();
    }

    @Generated
    public HttpSourceProcessor(HttpRequestExecutor httpRequestExecutor) {
        this.httpRequestExecutor = httpRequestExecutor;
    }
}

