/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetNextCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpGetSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpTableSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpRequestExecutor;
import org.sentrysoftware.metricshub.extension.snmp.ISnmpConfiguration;
import org.sentrysoftware.metricshub.extension.snmp.detection.SnmpGetCriterionProcessor;
import org.sentrysoftware.metricshub.extension.snmp.detection.SnmpGetNextCriterionProcessor;
import org.sentrysoftware.metricshub.extension.snmp.source.SnmpGetSourceProcessor;
import org.sentrysoftware.metricshub.extension.snmp.source.SnmpTableSourceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnmpExtension
implements IProtocolExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSnmpExtension.class);
    public static final String SNMP_OID = "1.3.6.1";
    public static final String GET = "get";
    public static final String GET_NEXT = "getNext";
    public static final String WALK = "walk";
    public static final String TABLE = "table";

    protected abstract AbstractSnmpRequestExecutor getRequestExecutor();

    protected abstract Class<? extends ISnmpConfiguration> getConfigurationClass();

    public Set<Class<? extends Source>> getSupportedSources() {
        return Set.of(SnmpTableSource.class, SnmpGetSource.class);
    }

    public Set<Class<? extends Criterion>> getSupportedCriteria() {
        return Set.of(SnmpGetCriterion.class, SnmpGetNextCriterion.class);
    }

    public Optional<Boolean> checkProtocol(TelemetryManager telemetryManager) {
        Class<? extends ISnmpConfiguration> configurationClass = this.getConfigurationClass();
        String hostname = telemetryManager.getHostname(List.of(configurationClass));
        String result = null;
        ISnmpConfiguration configuration = (ISnmpConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(configurationClass);
        if (configuration == null) {
            return Optional.empty();
        }
        log.info("Hostname {} - Performing {} protocol health check.", (Object)hostname, (Object)this.getIdentifier());
        log.info("Hostname {} - Checking SNMP protocol status. Sending Get Next request on {}.", (Object)hostname, (Object)SNMP_OID);
        try {
            result = this.getRequestExecutor().executeSNMPGetNext(SNMP_OID, configuration, hostname, true);
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking SNMP protocol status. SNMP exception when performing a SNMP Get Next query on {}: ", new Object[]{hostname, SNMP_OID, e});
        }
        return Optional.of(result != null);
    }

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager) {
        Function<TelemetryManager, ISnmpConfiguration> configurationRetriever = manager -> (ISnmpConfiguration)manager.getHostConfiguration().getConfigurations().get(this.getConfigurationClass());
        if (source instanceof SnmpTableSource) {
            SnmpTableSource snmpTableSource = (SnmpTableSource)source;
            return new SnmpTableSourceProcessor(this.getRequestExecutor(), configurationRetriever).process(snmpTableSource, connectorId, telemetryManager);
        }
        if (source instanceof SnmpGetSource) {
            SnmpGetSource snmpGetSource = (SnmpGetSource)source;
            return new SnmpGetSourceProcessor(this.getRequestExecutor(), configurationRetriever).process(snmpGetSource, connectorId, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process source %s.", telemetryManager.getHostname(), source != null ? source.getClass().getSimpleName() : "<null>"));
    }

    public CriterionTestResult processCriterion(Criterion criterion, String connectorId, TelemetryManager telemetryManager) {
        Function<TelemetryManager, ISnmpConfiguration> configurationRetriever = manager -> (ISnmpConfiguration)manager.getHostConfiguration().getConfigurations().get(this.getConfigurationClass());
        if (criterion instanceof SnmpGetCriterion) {
            SnmpGetCriterion snmpGetCriterion = (SnmpGetCriterion)criterion;
            return new SnmpGetCriterionProcessor(this.getRequestExecutor(), configurationRetriever).process(snmpGetCriterion, connectorId, telemetryManager);
        }
        if (criterion instanceof SnmpGetNextCriterion) {
            SnmpGetNextCriterion snmpGetNextCriterion = (SnmpGetNextCriterion)criterion;
            return new SnmpGetNextCriterionProcessor(this.getRequestExecutor(), configurationRetriever).process(snmpGetNextCriterion, connectorId, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process criterion %s.", telemetryManager.getHostname(), criterion != null ? criterion.getClass().getSimpleName() : "<null>"));
    }

    public Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> getConfigurationToSourceMapping() {
        return Map.of(this.getConfigurationClass(), Set.of(SnmpTableSource.class, SnmpGetSource.class));
    }

    public boolean isSupportedConfigurationType(String configurationType) {
        return this.getIdentifier().equalsIgnoreCase(configurationType);
    }

    public String executeQuery(IConfiguration configuration, JsonNode queryNode) {
        ISnmpConfiguration snmpConfiguration = (ISnmpConfiguration)configuration;
        String hostname = configuration.getHostname();
        String result = "Failed Executing SNMP query";
        String action = queryNode.get("action").asText();
        String oId = queryNode.get("oid").asText();
        AbstractSnmpRequestExecutor executor = this.getRequestExecutor();
        try {
            switch (action) {
                case "get": {
                    result = executor.executeSNMPGet(oId, snmpConfiguration, hostname, false);
                    break;
                }
                case "getNext": {
                    result = executor.executeSNMPGetNext(oId, snmpConfiguration, hostname, false);
                    break;
                }
                case "walk": {
                    result = executor.executeSNMPWalk(oId, snmpConfiguration, hostname, false);
                    break;
                }
                case "table": {
                    String[] columns = (String[])new ObjectMapper().convertValue((Object)queryNode.get("columns"), String[].class);
                    List<List<String>> resultList = executor.executeSNMPTable(oId, columns, snmpConfiguration, hostname, false);
                    result = TextTableHelper.generateTextTable((String[])columns, resultList);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Hostname %s - Invalid SNMP Operation", hostname));
                }
            }
        }
        catch (Exception e) {
            log.debug("Hostname {} - Error while executing SNMP {} query. Message: {}", new Object[]{hostname, action, e});
        }
        return result;
    }

    public static JsonMapper newObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }
}

