/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmp.detection;

import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetNextCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpRequestExecutor;
import org.sentrysoftware.metricshub.extension.snmp.ISnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpGetNextCriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnmpGetNextCriterionProcessor.class);
    @NonNull
    private AbstractSnmpRequestExecutor snmpRequestExecutor;
    @NonNull
    private Function<TelemetryManager, ISnmpConfiguration> configurationRetriever;
    private static final Pattern SNMP_GET_NEXT_VALUE_PATTERN = Pattern.compile("\\w+\\s+\\w+\\s+(.*)");

    public CriterionTestResult process(SnmpGetNextCriterion snmpGetNextCriterion, String connectorId, TelemetryManager telemetryManager) {
        if (snmpGetNextCriterion == null) {
            log.error("Hostname {} - Malformed SNMP GetNext criterion {}. Cannot process SNMP GetNext detection. Connector ID: {}.", new Object[]{telemetryManager.getHostname(), snmpGetNextCriterion, connectorId});
            return CriterionTestResult.empty();
        }
        ISnmpConfiguration snmpConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (snmpConfiguration == null) {
            log.debug("Hostname {} - The SNMP credentials are not configured. Cannot process SNMP GetNext criterion {}. Connector ID: {}.", new Object[]{telemetryManager.getHostname(), snmpGetNextCriterion, connectorId});
            return CriterionTestResult.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(snmpConfiguration.getClass()));
        try {
            String result = this.snmpRequestExecutor.executeSNMPGetNext(snmpGetNextCriterion.getOid(), snmpConfiguration, hostname, false);
            CriterionTestResult criterionTestResult = SnmpGetNextCriterionProcessor.checkSNMPGetNextResult(hostname, snmpGetNextCriterion.getOid(), snmpGetNextCriterion.getExpectedResult(), result);
            criterionTestResult.setResult(result);
            return criterionTestResult;
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was unsuccessful due to an exception. Message: %s. Connector ID: %s.", hostname, snmpGetNextCriterion.getOid(), e.getMessage(), connectorId);
            log.debug(message, (Throwable)e);
            return CriterionTestResult.builder().message(message).build();
        }
    }

    static CriterionTestResult checkSNMPGetNextValue(String hostname, String oid, String result) {
        String message;
        boolean success = false;
        if (result == null) {
            message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was unsuccessful due to a null result.", hostname, oid);
        } else if (result.isBlank()) {
            message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was unsuccessful due to an empty result.", hostname, oid);
        } else if (!result.startsWith(oid)) {
            message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was successful but the returned OID is not under the same tree. Returned OID: %s.", hostname, oid, result.split("\\s")[0]);
        } else {
            message = String.format("Hostname %s - Successful SNMP GetNext of %s. Returned result: %s.", hostname, oid, result);
            success = true;
        }
        log.debug(message);
        return CriterionTestResult.builder().message(message).success(success).build();
    }

    static CriterionTestResult checkSNMPGetNextExpectedValue(String hostname, String oid, String expected, String result) {
        Object message;
        boolean success = true;
        if (result == null) {
            message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was unsuccessful due to a null result.", hostname, oid);
            success = false;
        } else {
            Matcher matcher = SNMP_GET_NEXT_VALUE_PATTERN.matcher(result);
            if (matcher.find()) {
                String value = matcher.group(1);
                Pattern pattern = Pattern.compile(PslUtils.psl2JavaRegex((String)expected), 10);
                if (!pattern.matcher(value).find()) {
                    message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was successful but the value of the returned OID did not match with the expected result. ", hostname, oid);
                    message = (String)message + String.format("Expected value: %s - returned value %s.", expected, value);
                    success = false;
                } else {
                    message = String.format("Hostname %s - Successful SNMP GetNext of %s. Returned result: %s.", hostname, oid, result);
                }
            } else {
                message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was successful but the value cannot be extracted. ", hostname, oid);
                message = (String)message + String.format("Returned result: %s.", result);
                success = false;
            }
        }
        log.debug((String)message);
        return CriterionTestResult.builder().message((String)message).success(success).build();
    }

    static CriterionTestResult checkSNMPGetNextResult(String hostname, String oid, String expected, String result) {
        if (expected == null) {
            return SnmpGetNextCriterionProcessor.checkSNMPGetNextValue(hostname, oid, result);
        }
        return SnmpGetNextCriterionProcessor.checkSNMPGetNextExpectedValue(hostname, oid, expected, result);
    }

    @Generated
    public SnmpGetNextCriterionProcessor(@NonNull AbstractSnmpRequestExecutor snmpRequestExecutor, @NonNull Function<TelemetryManager, ISnmpConfiguration> configurationRetriever) {
        if (snmpRequestExecutor == null) {
            throw new IllegalArgumentException("snmpRequestExecutor is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        this.snmpRequestExecutor = snmpRequestExecutor;
        this.configurationRetriever = configurationRetriever;
    }
}

