/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmp.source;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpGetSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpRequestExecutor;
import org.sentrysoftware.metricshub.extension.snmp.ISnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpGetSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnmpGetSourceProcessor.class);
    @NonNull
    private AbstractSnmpRequestExecutor snmpRequestExecutor;
    @NonNull
    private Function<TelemetryManager, ISnmpConfiguration> configurationRetriever;

    public SourceTable process(SnmpGetSource snmpGetSource, String connectorId, TelemetryManager telemetryManager) {
        if (snmpGetSource == null) {
            log.error("Hostname {} - SNMP Get Source cannot be null, the SNMP Get operation will return an empty result.", (Object)telemetryManager.getHostname());
            return SourceTable.empty();
        }
        ISnmpConfiguration snmpConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (snmpConfiguration == null) {
            log.debug("Hostname {} - The SNMP credentials are not configured. Returning an empty table for SNMP Get Source {}.", (Object)telemetryManager.getHostname(), (Object)snmpGetSource);
            return SourceTable.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(snmpConfiguration.getClass()));
        try {
            String result = this.snmpRequestExecutor.executeSNMPGet(snmpGetSource.getOid(), snmpConfiguration, hostname, true);
            if (result != null) {
                return SourceTable.builder().table(Stream.of(Stream.of(result).collect(Collectors.toList())).collect(Collectors.toList())).build();
            }
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)connectorId, (String)snmpGetSource.getKey(), (String)String.format("SNMP Get: %s.", snmpGetSource.getOid()), (String)hostname, (Throwable)e);
        }
        return SourceTable.empty();
    }

    @Generated
    public SnmpGetSourceProcessor(@NonNull AbstractSnmpRequestExecutor snmpRequestExecutor, @NonNull Function<TelemetryManager, ISnmpConfiguration> configurationRetriever) {
        if (snmpRequestExecutor == null) {
            throw new IllegalArgumentException("snmpRequestExecutor is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        this.snmpRequestExecutor = snmpRequestExecutor;
        this.configurationRetriever = configurationRetriever;
    }
}

