/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmp.source;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpTableSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpRequestExecutor;
import org.sentrysoftware.metricshub.extension.snmp.ISnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpTableSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnmpTableSourceProcessor.class);
    @NonNull
    private AbstractSnmpRequestExecutor snmpRequestExecutor;
    @NonNull
    private Function<TelemetryManager, ISnmpConfiguration> configurationRetriever;

    public SourceTable process(SnmpTableSource snmpTableSource, String connectorId, TelemetryManager telemetryManager) {
        if (snmpTableSource == null) {
            log.error("Hostname {} - SNMP Get Table Source cannot be null, the SNMP Get Table operation will return an empty result.", (Object)telemetryManager.getHostname());
            return SourceTable.empty();
        }
        SourceTable sourceTable = new SourceTable();
        String selectedColumns = snmpTableSource.getSelectColumns();
        if (selectedColumns.isBlank()) {
            return SourceTable.empty();
        }
        String[] selectedColumnArray = selectedColumns.split("\\s*,\\s*");
        ISnmpConfiguration snmpConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (snmpConfiguration == null) {
            log.debug("Hostname {} - The SNMP credentials are not configured. Returning an empty table for SNMP Get Table Source {}.", (Object)telemetryManager.getHostname(), (Object)snmpTableSource);
            return SourceTable.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(snmpConfiguration.getClass()));
        try {
            List<List<String>> result = this.snmpRequestExecutor.executeSNMPTable(snmpTableSource.getOid(), selectedColumnArray, snmpConfiguration, hostname, true);
            sourceTable.setHeaders(Arrays.asList(selectedColumnArray));
            sourceTable.setTable(result);
            return sourceTable;
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)connectorId, (String)snmpTableSource.getKey(), (String)String.format("SNMP Table: %s", snmpTableSource.getOid()), (String)hostname, (Throwable)e);
            return SourceTable.empty();
        }
    }

    @Generated
    public SnmpTableSourceProcessor(@NonNull AbstractSnmpRequestExecutor snmpRequestExecutor, @NonNull Function<TelemetryManager, ISnmpConfiguration> configurationRetriever) {
        if (snmpRequestExecutor == null) {
            throw new IllegalArgumentException("snmpRequestExecutor is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        this.snmpRequestExecutor = snmpRequestExecutor;
        this.configurationRetriever = configurationRetriever;
    }
}

