/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmpv3;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.deserialization.MultiValueDeserializer;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;
import org.sentrysoftware.metricshub.extension.snmp.ISnmpConfiguration;
import org.sentrysoftware.metricshub.extension.snmpv3.AuthTypeDeserializer;
import org.sentrysoftware.metricshub.extension.snmpv3.PrivacyDeserializer;

public class SnmpV3Configuration
implements ISnmpConfiguration {
    private static final String SNMP_V3_DESCRIPTION = "SNMP V3";
    private static final int V3 = 3;
    private static final String INVALID_AUTH_TYPE_EXCEPTION_MESSAGE = "Invalid authentication type: ";
    private static final String INVALID_PRIVACY_VALUE_EXCEPTION_MESSAGE = "Invalid privacy value: ";
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer port;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private Long timeout;
    private String contextName;
    @JsonDeserialize(using=AuthTypeDeserializer.class)
    private AuthType authType;
    @JsonDeserialize(using=PrivacyDeserializer.class)
    private Privacy privacy;
    private String username;
    private char[] privacyPassword;
    private char[] password;
    private int[] retryIntervals;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    private String hostname;

    public String toString() {
        Object description = SNMP_V3_DESCRIPTION;
        if (this.username != null) {
            description = (String)description + " as " + this.username;
        }
        if (this.privacy != null && this.privacy != Privacy.NO_ENCRYPTION) {
            description = (String)description + " (" + String.valueOf((Object)this.privacy) + "-encrypted)";
        }
        return description;
    }

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.port, attr -> attr == null || attr < 1 || attr > 65535, () -> String.format("Resource %s - Invalid port configured for protocol %s. Port value returned: %s. This resource will not be monitored. Please verify the configured port value.", resourceKey, SNMP_V3_DESCRIPTION, this.port));
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, SNMP_V3_DESCRIPTION, this.timeout));
        StringHelper.validateConfigurationAttribute((Object)this.username, attr -> attr == null || attr.isBlank(), () -> String.format("Resource %s - No username configured for protocol %s. This resource will not be monitored. Please verify the configured username.", resourceKey, "SNNP V3"));
        StringHelper.validateConfigurationAttribute((Object)((Object)this.authType), attr -> attr == null, () -> String.format("Resource %s - No username configured for protocol %s. This resource will not be monitored. Please verify the configured authtype.", resourceKey, "SNNP V3"));
    }

    @Override
    public int getIntVersion() {
        return 3;
    }

    public IConfiguration copy() {
        return SnmpV3Configuration.builder().authType(this.authType).contextName(this.contextName).password(this.password).port(this.port).privacy(this.privacy).privacyPassword(this.privacyPassword).retryIntervals(this.retryIntervals).timeout(this.timeout).username(this.username).hostname(this.hostname).build();
    }

    @Generated
    private static Integer $default$port() {
        return 161;
    }

    @Generated
    private static Long $default$timeout() {
        return 120L;
    }

    @Generated
    public static SnmpV3ConfigurationBuilder builder() {
        return new SnmpV3ConfigurationBuilder();
    }

    @Override
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getContextName() {
        return this.contextName;
    }

    @Generated
    public AuthType getAuthType() {
        return this.authType;
    }

    @Generated
    public Privacy getPrivacy() {
        return this.privacy;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPrivacyPassword() {
        return this.privacyPassword;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public int[] getRetryIntervals() {
        return this.retryIntervals;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    @JsonDeserialize(using=AuthTypeDeserializer.class)
    @Generated
    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    @JsonDeserialize(using=PrivacyDeserializer.class)
    @Generated
    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPrivacyPassword(char[] privacyPassword) {
        this.privacyPassword = privacyPassword;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setRetryIntervals(int[] retryIntervals) {
        this.retryIntervals = retryIntervals;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpV3Configuration)) {
            return false;
        }
        SnmpV3Configuration other = (SnmpV3Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$contextName = this.getContextName();
        String other$contextName = other.getContextName();
        if (this$contextName == null ? other$contextName != null : !this$contextName.equals(other$contextName)) {
            return false;
        }
        AuthType this$authType = this.getAuthType();
        AuthType other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !((Object)((Object)this$authType)).equals((Object)other$authType)) {
            return false;
        }
        Privacy this$privacy = this.getPrivacy();
        Privacy other$privacy = other.getPrivacy();
        if (this$privacy == null ? other$privacy != null : !((Object)((Object)this$privacy)).equals((Object)other$privacy)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPrivacyPassword(), other.getPrivacyPassword())) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        if (!Arrays.equals(this.getRetryIntervals(), other.getRetryIntervals())) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpV3Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $contextName = this.getContextName();
        result = result * 59 + ($contextName == null ? 43 : $contextName.hashCode());
        AuthType $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : ((Object)((Object)$authType)).hashCode());
        Privacy $privacy = this.getPrivacy();
        result = result * 59 + ($privacy == null ? 43 : ((Object)((Object)$privacy)).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPrivacyPassword());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        result = result * 59 + Arrays.hashCode(this.getRetryIntervals());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    @Generated
    public SnmpV3Configuration(Integer port, Long timeout, String contextName, AuthType authType, Privacy privacy, String username, char[] privacyPassword, char[] password, int[] retryIntervals, String hostname) {
        this.port = port;
        this.timeout = timeout;
        this.contextName = contextName;
        this.authType = authType;
        this.privacy = privacy;
        this.username = username;
        this.privacyPassword = privacyPassword;
        this.password = password;
        this.retryIntervals = retryIntervals;
        this.hostname = hostname;
    }

    @Generated
    public SnmpV3Configuration() {
        this.port = SnmpV3Configuration.$default$port();
        this.timeout = SnmpV3Configuration.$default$timeout();
    }

    public static enum Privacy {
        NO_ENCRYPTION,
        AES,
        DES;


        public static Privacy interpretValueOf(@NonNull String privacy) {
            if (privacy == null) {
                throw new IllegalArgumentException("privacy is marked non-null but is null");
            }
            String lowerCasePrivacy = privacy.toLowerCase();
            if (lowerCasePrivacy.equals("none") || lowerCasePrivacy.equals("no")) {
                return NO_ENCRYPTION;
            }
            if (lowerCasePrivacy.equals("aes")) {
                return AES;
            }
            if (lowerCasePrivacy.equals("des")) {
                return DES;
            }
            throw new IllegalArgumentException(SnmpV3Configuration.INVALID_PRIVACY_VALUE_EXCEPTION_MESSAGE + privacy);
        }

        @Generated
        private Privacy() {
        }
    }

    public static enum AuthType {
        NO_AUTH,
        MD5,
        SHA;


        public static AuthType interpretValueOf(@NonNull String authType) {
            if (authType == null) {
                throw new IllegalArgumentException("authType is marked non-null but is null");
            }
            String lowerCaseAuthType = authType.toLowerCase();
            if (lowerCaseAuthType.contains("no") && lowerCaseAuthType.contains("auth")) {
                return NO_AUTH;
            }
            if (lowerCaseAuthType.contains("md5")) {
                return MD5;
            }
            if (lowerCaseAuthType.contains("sha")) {
                return SHA;
            }
            throw new IllegalArgumentException(SnmpV3Configuration.INVALID_AUTH_TYPE_EXCEPTION_MESSAGE + authType);
        }

        @Generated
        private AuthType() {
        }
    }

    @Generated
    public static class SnmpV3ConfigurationBuilder {
        @Generated
        private boolean port$set;
        @Generated
        private Integer port$value;
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;
        @Generated
        private String contextName;
        @Generated
        private AuthType authType;
        @Generated
        private Privacy privacy;
        @Generated
        private String username;
        @Generated
        private char[] privacyPassword;
        @Generated
        private char[] password;
        @Generated
        private int[] retryIntervals;
        @Generated
        private String hostname;

        @Generated
        SnmpV3ConfigurationBuilder() {
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public SnmpV3ConfigurationBuilder port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public SnmpV3ConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public SnmpV3ConfigurationBuilder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        @JsonDeserialize(using=AuthTypeDeserializer.class)
        @Generated
        public SnmpV3ConfigurationBuilder authType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        @JsonDeserialize(using=PrivacyDeserializer.class)
        @Generated
        public SnmpV3ConfigurationBuilder privacy(Privacy privacy) {
            this.privacy = privacy;
            return this;
        }

        @Generated
        public SnmpV3ConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public SnmpV3ConfigurationBuilder privacyPassword(char[] privacyPassword) {
            this.privacyPassword = privacyPassword;
            return this;
        }

        @Generated
        public SnmpV3ConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @Generated
        public SnmpV3ConfigurationBuilder retryIntervals(int[] retryIntervals) {
            this.retryIntervals = retryIntervals;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MultiValueDeserializer.class)
        @Generated
        public SnmpV3ConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public SnmpV3Configuration build() {
            Integer port$value = this.port$value;
            if (!this.port$set) {
                port$value = SnmpV3Configuration.$default$port();
            }
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = SnmpV3Configuration.$default$timeout();
            }
            return new SnmpV3Configuration(port$value, timeout$value, this.contextName, this.authType, this.privacy, this.username, this.privacyPassword, this.password, this.retryIntervals, this.hostname);
        }

        @Generated
        public String toString() {
            return "SnmpV3Configuration.SnmpV3ConfigurationBuilder(port$value=" + this.port$value + ", timeout$value=" + this.timeout$value + ", contextName=" + this.contextName + ", authType=" + String.valueOf((Object)this.authType) + ", privacy=" + String.valueOf((Object)this.privacy) + ", username=" + this.username + ", privacyPassword=" + Arrays.toString(this.privacyPassword) + ", password=" + Arrays.toString(this.password) + ", retryIntervals=" + Arrays.toString(this.retryIntervals) + ", hostname=" + this.hostname + ")";
        }
    }
}

