/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmpv3;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpExtension;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpRequestExecutor;
import org.sentrysoftware.metricshub.extension.snmpv3.SnmpV3Configuration;
import org.sentrysoftware.metricshub.extension.snmpv3.SnmpV3RequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpV3Extension
extends AbstractSnmpExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnmpV3Extension.class);
    private static final String IDENTIFIER = "snmpv3";
    private SnmpV3RequestExecutor snmpV3RequestExecutor = new SnmpV3RequestExecutor();

    public boolean isValidConfiguration(IConfiguration configuration) {
        return configuration instanceof SnmpV3Configuration;
    }

    public IConfiguration buildConfiguration(@NonNull String configurationType, @NonNull JsonNode jsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        if (configurationType == null) {
            throw new IllegalArgumentException("configurationType is marked non-null but is null");
        }
        if (jsonNode == null) {
            throw new IllegalArgumentException("jsonNode is marked non-null but is null");
        }
        try {
            SnmpV3Configuration snmpV3Configuration = (SnmpV3Configuration)SnmpV3Extension.newObjectMapper().treeToValue((TreeNode)jsonNode, SnmpV3Configuration.class);
            if (decrypt != null) {
                char[] password = snmpV3Configuration.getPassword();
                char[] privacyPassword = snmpV3Configuration.getPrivacyPassword();
                if (password != null) {
                    snmpV3Configuration.setPassword((char[])decrypt.apply(password));
                }
                if (privacyPassword != null) {
                    snmpV3Configuration.setPrivacyPassword((char[])decrypt.apply(privacyPassword));
                }
            }
            return snmpV3Configuration;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error while reading SNMP V3 Configuration. Error: %s", e.getMessage());
            log.error(errorMessage);
            log.debug("Error while reading SNMP V3 Configuration. Stack trace:", (Throwable)e);
            throw new InvalidConfigurationException(errorMessage, (Throwable)e);
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    protected AbstractSnmpRequestExecutor getRequestExecutor() {
        return this.snmpV3RequestExecutor;
    }

    protected Class<SnmpV3Configuration> getConfigurationClass() {
        return SnmpV3Configuration.class;
    }
}

