/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.io.InputStream;
import uk.co.westhawk.snmp.stack.AsnDecoderBase;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.AsnTrapPduv1Sequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.util.SnmpUtilities;

class AsnDecoderv1
extends AsnDecoderBase {
    private static final String version_id = "@(#)$Id: AsnDecoderv1.java,v 3.3 2006/02/09 14:16:36 birgit Exp $ Copyright Westhawk Ltd";

    AsnDecoderv1() {
    }

    AsnSequence DecodeSNMP(InputStream in, String community) throws IOException, DecodingException {
        AsnSequence asnTopSeq = this.getAsnSequence(in);
        int snmpVersion = this.getSNMPVersion(asnTopSeq);
        if (snmpVersion != 0) {
            String str = SnmpUtilities.getSnmpVersionString(snmpVersion);
            String msg = "Wrong SNMP version: expected SNMPv1, received " + str;
            throw new DecodingException(msg);
        }
        String comm = this.getCommunity(asnTopSeq);
        if (!comm.equals(community)) {
            String msg = "Wrong community: expected " + community + ", received " + comm;
            throw new DecodingException(msg);
        }
        AsnSequence seqPdu = null;
        seqPdu = (AsnPduSequence)asnTopSeq.findPdu();
        if (seqPdu == null) {
            seqPdu = (AsnTrapPduv1Sequence)asnTopSeq.findTrapPduv1();
        }
        return seqPdu;
    }
}

