/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import uk.co.westhawk.snmp.stack.AsnEncoderBase;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.SnmpContextv3Basis;
import uk.co.westhawk.snmp.stack.TimeWindowNode;
import uk.co.westhawk.snmp.util.SnmpUtilities;

class AsnEncoderv3
extends AsnEncoderBase {
    private static final String version_id = "@(#)$Id: AsnEncoderv3.java,v 3.5 2009/03/05 12:48:59 birgita Exp $ Copyright Westhawk Ltd";
    static byte[] dummyFingerPrint = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    AsnEncoderv3() {
    }

    byte[] EncodeSNMPv3(SnmpContextv3Basis context, int contextMsgId, TimeWindowNode node, byte msg_type, int pduId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        ByteArrayOutputStream bout;
        AsnOctets privOct;
        AsnSequence asnTopSeq = new AsnSequence();
        AsnSequence asnHeaderData = new AsnSequence();
        asnHeaderData.add(new AsnInteger(contextMsgId));
        asnHeaderData.add(new AsnInteger(context.getMaxRecvSize()));
        asnHeaderData.add(new AsnOctets(this.getMsgFlags(context, msg_type)));
        asnHeaderData.add(new AsnInteger(3));
        AsnSequence asnPlainScopedPdu = new AsnSequence();
        asnPlainScopedPdu.add(new AsnOctets(context.getContextEngineId()));
        asnPlainScopedPdu.add(new AsnOctets(context.getContextName()));
        AsnObject asnPduObject = this.EncodePdu(msg_type, pduId, errstat, errind, ve);
        asnPlainScopedPdu.add(asnPduObject);
        if (AsnObject.debug > 10) {
            System.out.println("\nEncode USM: node " + node.toString());
        }
        AsnSequence asnSecurityObject = new AsnSequence();
        byte[] engineIdBytes = SnmpUtilities.toBytes(node.getSnmpEngineId());
        asnSecurityObject.add(new AsnOctets(engineIdBytes));
        asnSecurityObject.add(new AsnInteger(node.getSnmpEngineBoots()));
        asnSecurityObject.add(new AsnInteger(node.getSnmpEngineTime()));
        asnSecurityObject.add(new AsnOctets(context.getUserName()));
        AsnOctets fingerPrintOct = context.isUseAuthentication() ? new AsnOctets(dummyFingerPrint) : new AsnOctets("");
        asnSecurityObject.add(fingerPrintOct);
        AsnOctets asnEncryptedScopedPdu = null;
        if (context.isUsePrivacy()) {
            byte[] passwKey;
            byte[] privKey = null;
            int aprot = context.getAuthenticationProtocol();
            if (aprot == 0) {
                passwKey = context.getPrivacyPasswordKeyMD5();
                privKey = SnmpUtilities.getLocalizedKeyMD5(passwKey, node.getSnmpEngineId());
            } else {
                passwKey = context.getPrivacyPasswordKeySHA1();
                privKey = SnmpUtilities.getLocalizedKeySHA1(passwKey, node.getSnmpEngineId());
            }
            int pprot = context.getPrivacyProtocol();
            byte[] salt = null;
            salt = pprot == 3 ? SnmpUtilities.getSaltAES() : SnmpUtilities.getSaltDES(node.getSnmpEngineBoots());
            privOct = new AsnOctets(salt);
            bout = new ByteArrayOutputStream();
            asnPlainScopedPdu.write(bout);
            byte[] plaintext = bout.toByteArray();
            byte[] encryptedText = null;
            encryptedText = pprot == 3 ? SnmpUtilities.AESencrypt(plaintext, privKey, node.getSnmpEngineBoots(), node.getSnmpEngineTime(), salt) : SnmpUtilities.DESencrypt(plaintext, privKey, salt);
            asnEncryptedScopedPdu = new AsnOctets(encryptedText);
            if (AsnObject.debug > 10) {
                System.out.println("Encrypted body  with " + SnmpContextv3Basis.ProtocolNames[pprot]);
            }
        } else {
            privOct = new AsnOctets("");
        }
        asnSecurityObject.add(privOct);
        ByteArrayOutputStream secOut = new ByteArrayOutputStream();
        asnSecurityObject.write(secOut);
        byte[] bytes = secOut.toByteArray();
        AsnOctets asnSecurityParameters = new AsnOctets(bytes);
        asnTopSeq.add(new AsnInteger(3));
        asnTopSeq.add(asnHeaderData);
        asnTopSeq.add(asnSecurityParameters);
        if (context.isUsePrivacy()) {
            asnTopSeq.add(asnEncryptedScopedPdu);
        } else {
            asnTopSeq.add(asnPlainScopedPdu);
        }
        if (AsnObject.debug > 10) {
            System.out.println("\n" + this.getClass().getName() + ".EncodeSNMPv3(): ");
        }
        bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        int sz = bout.size();
        if (sz > context.getMaxRecvSize()) {
            throw new EncodingException("Packet size (" + sz + ") is > maximum size (" + context.getMaxRecvSize() + ")");
        }
        byte[] message = bout.toByteArray();
        if (context.isUseAuthentication()) {
            byte[] authkey;
            byte[] passwKey;
            byte[] calcFingerPrint = null;
            int prot = context.getAuthenticationProtocol();
            if (prot == 0) {
                passwKey = context.getAuthenticationPasswordKeyMD5();
                authkey = SnmpUtilities.getLocalizedKeyMD5(passwKey, node.getSnmpEngineId());
                calcFingerPrint = SnmpUtilities.getFingerPrintMD5(authkey, message);
            } else {
                passwKey = context.getAuthenticationPasswordKeySHA1();
                authkey = SnmpUtilities.getLocalizedKeySHA1(passwKey, node.getSnmpEngineId());
                calcFingerPrint = SnmpUtilities.getFingerPrintSHA1(authkey, message);
            }
            int usmPos = asnSecurityParameters.getContentsPos();
            int fpPos = fingerPrintOct.getContentsPos();
            fpPos += usmPos;
            if (AsnObject.debug > 10) {
                int fpLength = fingerPrintOct.getContentsLength();
                String str = "Pos finger print = " + fpPos + ", len = " + fpLength;
                SnmpUtilities.dumpBytes(str, calcFingerPrint);
            }
            System.arraycopy(calcFingerPrint, 0, message, fpPos, dummyFingerPrint.length);
        }
        return message;
    }

    private byte[] getMsgFlags(SnmpContextv3Basis context, byte msg_type) throws EncodingException {
        int authMask = 0;
        if (context.isUseAuthentication()) {
            authMask = 1;
        }
        int privMask = 0;
        if (context.isUsePrivacy()) {
            if (context.isUseAuthentication()) {
                privMask = 2;
            } else {
                throw new EncodingException("Encryption without authentication is not allowed");
            }
        }
        int reportMask = 0;
        if (!context.isAuthoritative(msg_type)) {
            reportMask = 4;
        }
        byte[] msgFlags = new byte[]{(byte)(authMask | privMask | reportMask)};
        return msgFlags;
    }
}

