/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.internaldb;

import java.util.List;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.InternalDbQuerySource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.ISourceComputationExtension;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.internaldb.SqlClientExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalDbExtension
implements ISourceComputationExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalDbExtension.class);

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager) {
        String hostname = telemetryManager.getHostname();
        if (source == null) {
            log.warn("Hostname {} - Internal DB Query Source cannot be null, the SQL operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        if (!(source instanceof InternalDbQuerySource)) {
            log.warn("Hostname {} - Internal DB Query Source is invalid, the SQL operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        InternalDbQuerySource internalDbQuery = (InternalDbQuerySource)source;
        List sqlTables = internalDbQuery.getTables();
        if (sqlTables == null) {
            log.debug("Hostname {} - Table list in the Internal DB Query Source cannot be null, the SQL operation {} will return an empty result.", (Object)hostname, (Object)internalDbQuery);
            return SourceTable.empty();
        }
        String query = internalDbQuery.getQuery();
        if (query == null || query.isBlank()) {
            log.debug("Hostname {} - Query in the Internal DB Query Source cannot be null, the SQL operation {} will return an empty result.", (Object)hostname, (Object)internalDbQuery);
            return SourceTable.empty();
        }
        List<List<String>> executeSqlQuery = new SqlClientExecutor(telemetryManager, connectorId).executeQuery(sqlTables, query);
        SourceTable sourceTable = new SourceTable();
        if (!executeSqlQuery.isEmpty()) {
            sourceTable.setTable(executeSqlQuery);
        }
        LoggingHelper.debug(() -> log.trace("Executed Internal DB Query request:{}\n- Result:\n{}\n", (Object)query, (Object)TextTableHelper.generateTextTable((List)executeSqlQuery)));
        return sourceTable;
    }

    public boolean isValidSource(Source source) {
        return source instanceof InternalDbQuerySource;
    }
}

