/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.internaldb;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.model.common.SqlColumn;
import org.sentrysoftware.metricshub.engine.connector.model.common.SqlTable;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlClientExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlClientExecutor.class);
    private TelemetryManager telemetryManager;
    private String connectorId;

    public List<List<String>> executeQuery(List<SqlTable> sqlTables, String query) {
        List<List<String>> list;
        block11: {
            if (sqlTables == null) {
                log.error("Malformed Internal DB Query Source, no SQL Table is provided.");
                return new ArrayList<List<String>>();
            }
            if (query == null) {
                log.error("Malformed Internal DB Query Source, no SQL Query is provided.");
                return new ArrayList<List<String>>();
            }
            String hostId = this.telemetryManager.getHostConfiguration().getHostId();
            String connectionName = "jdbc:h2:mem:" + hostId + UUID.randomUUID().toString();
            Connection connection = DriverManager.getConnection(connectionName);
            try {
                for (SqlTable sqlTable : sqlTables) {
                    this.createAndInsert(sqlTable, connection);
                }
                list = this.executeQuery(query, connection);
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    log.error("Error when creating the database for the Internal DB Query: {}", (Object)exception.getMessage());
                    log.debug("SQL Exception: ", (Throwable)exception);
                    return new ArrayList<List<String>>();
                }
            }
            connection.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<List<String>> executeQuery(String query, Connection connection) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            if (resultSet == null) {
                log.error("The Internal DB Query {} returned a null result.", (Object)query);
                ArrayList<List<String>> arrayList = result;
                return arrayList;
            }
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnsNumber = rsmd.getColumnCount();
            while (resultSet.next()) {
                ArrayList<String> row = new ArrayList<String>();
                for (int i = 1; i <= columnsNumber; ++i) {
                    String resultValue = resultSet.getString(i);
                    row.add(resultValue != null ? resultValue : "");
                }
                result.add(row);
            }
            return result;
        }
        catch (SQLException exception) {
            log.error("Error when executing Internal DB Query {}: {}", (Object)query, (Object)exception.getMessage());
            log.debug("SQL Exception: ", (Throwable)exception);
        }
        return result;
    }

    private void createAndInsert(SqlTable sqlTable, Connection connection) {
        String createTableQuery = this.createTableQuery(sqlTable);
        if (createTableQuery == null) {
            log.debug("Error when creating Internal DB Query CREATE TABLE query for source {}", (Object)sqlTable.getSource());
            return;
        }
        try {
            Statement statement = connection.createStatement();
            statement.execute(createTableQuery);
            log.debug("Executing CREATE TABLE query: {}", (Object)createTableQuery);
        }
        catch (SQLException exception) {
            log.error("Error when executing CREATE TABLE query {}: {}", (Object)createTableQuery, (Object)exception.getMessage());
            log.debug("CREATE TABLE SQL Exception: ", (Throwable)exception);
            return;
        }
        String insertTableQuery = this.insertTableQuery(sqlTable);
        if (insertTableQuery == null) {
            return;
        }
        try {
            Statement statement = connection.createStatement();
            statement.execute(insertTableQuery);
            log.debug("Executing INSERT TABLE query: {}", (Object)insertTableQuery);
        }
        catch (SQLException exception) {
            log.error("Error when executing INSERT TABLE query {}: {}", (Object)insertTableQuery, (Object)exception.getMessage());
            log.debug("INSERT TABLE SQL Exception: ", (Throwable)exception);
        }
    }

    private String createTableQuery(SqlTable sqlTable) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("CREATE TABLE ");
        String alias = sqlTable.getAlias().strip();
        if (alias.isBlank() || alias.contains(";") || alias.contains(" ") || alias.contains("\"")) {
            log.error("Invalid alias {} for the source {}", (Object)sqlTable.getAlias(), (Object)sqlTable.getSource());
            return null;
        }
        queryBuilder.append(alias);
        queryBuilder.append(" (");
        ArrayList<String> columnNameType = new ArrayList<String>();
        for (SqlColumn sqlColumn : sqlTable.getColumns()) {
            String name = sqlColumn.getName();
            if (name == null || name.isBlank()) {
                log.error("Invalid name in lookup source table {}", (Object)sqlTable.getSource());
                return null;
            }
            String type = sqlColumn.getType();
            if (type == null || type.isBlank()) {
                log.error("Invalid type for column {} in lookup source table {}", (Object)name, (Object)sqlTable.getSource());
                return null;
            }
            int number = sqlColumn.getNumber();
            if (number < 1) {
                log.error("Wrong number {} for column {} in lookup source table {}", new Object[]{number, name, sqlTable.getSource()});
                return null;
            }
            columnNameType.add(String.join((CharSequence)" ", name, type));
        }
        queryBuilder.append(String.join((CharSequence)",", columnNameType));
        queryBuilder.append(");");
        return queryBuilder.toString();
    }

    private String insertTableQuery(SqlTable sqlTable) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("INSERT INTO ");
        String alias = sqlTable.getAlias().strip();
        queryBuilder.append(alias);
        queryBuilder.append(" (");
        ArrayList columnNames = new ArrayList();
        sqlTable.getColumns().stream().forEach(sqlColumn -> columnNames.add(sqlColumn.getName()));
        queryBuilder.append(String.join((CharSequence)",", columnNames));
        queryBuilder.append(") VALUES ");
        String valuesToInsert = this.formatInsertValues(sqlTable);
        if (valuesToInsert == null) {
            return null;
        }
        queryBuilder.append(valuesToInsert);
        queryBuilder.append(";");
        return queryBuilder.toString();
    }

    private String formatInsertValues(SqlTable sqlTable) {
        SourceTable sourceTable = (SourceTable)SourceTable.lookupSourceTable((String)sqlTable.getSource(), (String)this.connectorId, (TelemetryManager)this.telemetryManager).get();
        if (sourceTable == null) {
            log.error("The source table {} is not found during the Internal DB Query job. Skip processing.", (Object)sqlTable.getSource());
            return null;
        }
        List table = sourceTable.getTable();
        if (table == null || table.isEmpty()) {
            log.error("The source table {} is empty. Skip Internal DB Query job processing.", (Object)sqlTable.getSource());
            return null;
        }
        List sqlColumns = sqlTable.getColumns();
        ArrayList<CallSite> columnValues = new ArrayList<CallSite>();
        for (List row : table) {
            ArrayList<Object> rowValues = new ArrayList<Object>();
            for (SqlColumn sqlColumn : sqlColumns) {
                String separator = sqlColumn.getType().contains("CHAR") ? "'" : "";
                String value = (String)row.get(sqlColumn.getNumber() - 1);
                rowValues.add(value != null && !value.isEmpty() ? separator + value + separator : "NULL");
            }
            columnValues.add((CallSite)((Object)("(" + String.join((CharSequence)",", rowValues) + ")")));
        }
        return String.join((CharSequence)",", columnValues);
    }

    @Generated
    public static SqlClientExecutorBuilder builder() {
        return new SqlClientExecutorBuilder();
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlClientExecutor)) {
            return false;
        }
        SqlClientExecutor other = (SqlClientExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !this$telemetryManager.equals(other$telemetryManager)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        return !(this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SqlClientExecutor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : $telemetryManager.hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SqlClientExecutor(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", connectorId=" + this.getConnectorId() + ")";
    }

    @Generated
    public SqlClientExecutor(TelemetryManager telemetryManager, String connectorId) {
        this.telemetryManager = telemetryManager;
        this.connectorId = connectorId;
    }

    @Generated
    public SqlClientExecutor() {
    }

    @Generated
    public static class SqlClientExecutorBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private String connectorId;

        @Generated
        SqlClientExecutorBuilder() {
        }

        @Generated
        public SqlClientExecutorBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public SqlClientExecutorBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public SqlClientExecutor build() {
            return new SqlClientExecutor(this.telemetryManager, this.connectorId);
        }

        @Generated
        public String toString() {
            return "SqlClientExecutor.SqlClientExecutorBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", connectorId=" + this.connectorId + ")";
        }
    }
}

