/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmp;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.ThreadHelper;
import org.sentrysoftware.metricshub.extension.snmp.ISnmpConfiguration;
import org.sentrysoftware.snmp.client.SnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnmpRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSnmpRequestExecutor.class);

    protected abstract SnmpClient createSnmpClient(ISnmpConfiguration var1, String var2) throws IOException;

    @WithSpan(value="SNMP Get Next")
    public String executeSNMPGetNext(@SpanAttribute(value="snmp.oid") @NonNull String oid, @SpanAttribute(value="snmp.config") @NonNull ISnmpConfiguration configuration, @SpanAttribute(value="host.hostname") @NonNull String hostname, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        LoggingHelper.trace(() -> log.trace("Executing SNMP GetNext request:\n- OID: {}\n", (Object)oid));
        long startTime = System.currentTimeMillis();
        String result = (String)this.executeSnmpGetRequest(SnmpGetRequest.GETNEXT, oid, configuration, hostname, null, logMode);
        long responseTime = System.currentTimeMillis() - startTime;
        LoggingHelper.trace(() -> log.trace("Executed SNMP GetNext request:\n- OID: {}\n- Result: {}\n- response-time: {}\n", new Object[]{oid, result, responseTime}));
        return result;
    }

    @WithSpan(value="SNMP Get")
    public String executeSNMPGet(@SpanAttribute(value="snmp.oid") @NonNull String oid, @SpanAttribute(value="snmp.config") @NonNull ISnmpConfiguration configuration, @SpanAttribute(value="host.hostname") @NonNull String hostname, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        LoggingHelper.trace(() -> log.trace("Executing SNMP Get request:\n- OID: {}\n", (Object)oid));
        long startTime = System.currentTimeMillis();
        String result = (String)this.executeSnmpGetRequest(SnmpGetRequest.GET, oid, configuration, hostname, null, logMode);
        long responseTime = System.currentTimeMillis() - startTime;
        LoggingHelper.trace(() -> log.trace("Executed SNMP Get request:\n- OID: {}\n- Result: {}\n- response-time: {}\n", new Object[]{oid, result, responseTime}));
        return result;
    }

    @WithSpan(value="SNMP Get Table")
    public List<List<String>> executeSNMPTable(@SpanAttribute(value="snmp.oid") @NonNull String oid, @SpanAttribute(value="snmp.columns") @NonNull String[] selectColumnArray, @SpanAttribute(value="snmp.config") @NonNull ISnmpConfiguration configuration, @SpanAttribute(value="host.hostname") @NonNull String hostname, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        if (selectColumnArray == null) {
            throw new IllegalArgumentException("selectColumnArray is marked non-null but is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        LoggingHelper.trace(() -> log.trace("Executing SNMP Table request:\n- OID: {}\n- Columns: {}\n", (Object)oid, (Object)Arrays.toString(selectColumnArray)));
        long startTime = System.currentTimeMillis();
        List result = (List)this.executeSnmpGetRequest(SnmpGetRequest.TABLE, oid, configuration, hostname, selectColumnArray, logMode);
        long responseTime = System.currentTimeMillis() - startTime;
        LoggingHelper.trace(() -> log.trace("Executed SNMP Table request:\n- OID: {}\n- Columns: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{oid, Arrays.toString(selectColumnArray), TextTableHelper.generateTextTable((String[])selectColumnArray, (List)result), responseTime}));
        return result;
    }

    protected <T> T executeSnmpGetRequest(SnmpGetRequest request, String oid, ISnmpConfiguration protocol, String hostname, String[] selectColumnArray, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)ThreadHelper.execute(() -> {
            SnmpClient snmpClient = this.createSnmpClient(protocol, hostname);
            try {
                switch (request.ordinal()) {
                    case 0: {
                        String string = snmpClient.get(oid);
                        return string;
                    }
                    case 1: {
                        String string = snmpClient.getNext(oid);
                        return string;
                    }
                    case 2: {
                        List<List<String>> list = snmpClient.table(oid, selectColumnArray);
                        return list;
                    }
                    case 3: {
                        String string = snmpClient.walk(oid);
                        return string;
                    }
                }
                try {
                    throw new IllegalArgumentException("Not implemented.");
                }
                catch (Exception e) {
                    if (logMode) {
                        log.warn("Hostname {} - Error detected when running SNMP {} Query OID: {}. Error message: {}.", new Object[]{hostname, request, oid, e.getMessage()});
                    }
                    Object var9_13 = null;
                    return var9_13;
                }
            }
            finally {
                snmpClient.freeResources();
            }
        }, (long)protocol.getTimeout());
    }

    @WithSpan(value="SNMP Walk")
    public String executeSNMPWalk(@SpanAttribute(value="snmp.oid") @NonNull String oid, @SpanAttribute(value="snmp.config") @NonNull ISnmpConfiguration configuration, @SpanAttribute(value="host.hostname") @NonNull String hostname, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        LoggingHelper.trace(() -> log.trace("Executing SNMP Walk request:\n- OID: {}\n", (Object)oid));
        long startTime = System.currentTimeMillis();
        String result = (String)this.executeSnmpGetRequest(SnmpGetRequest.WALK, oid, configuration, hostname, null, logMode);
        long responseTime = System.currentTimeMillis() - startTime;
        LoggingHelper.trace(() -> log.trace("Executed SNMP Walk request:\n- OID: {}\n- Result: {}\n- response-time: {}\n", new Object[]{oid, result, responseTime}));
        return result;
    }

    public static enum SnmpGetRequest {
        GET,
        GETNEXT,
        TABLE,
        WALK;

    }
}

