/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmp;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.deserialization.MultiValueDeserializer;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;
import org.sentrysoftware.metricshub.extension.snmp.ISnmpConfiguration;
import org.sentrysoftware.metricshub.extension.snmp.SnmpVersionDeserializer;

public class SnmpConfiguration
implements ISnmpConfiguration {
    private static final String INVALID_SNMP_VERSION_EXCEPTION_MESSAGE = "Invalid SNMP version: ";
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=SnmpVersionDeserializer.class)
    private final SnmpVersion version;
    @JsonSetter(nulls=Nulls.SKIP)
    private char[] community;
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer port;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private final Long timeout;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    private String hostname;
    @JsonSetter(nulls=Nulls.SKIP)
    private int[] retryIntervals;

    public String toString() {
        return this.version.getDisplayName() + " (" + new String(this.community) + ")";
    }

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        SnmpVersion snmpVersion = this.version;
        String displayName = snmpVersion.getDisplayName();
        StringHelper.validateConfigurationAttribute((Object)this.community, attr -> attr == null || ((char[])attr).length == 0, () -> String.format("Resource %s - No community string configured for %s. This resource will not be monitored.", resourceKey, displayName));
        StringHelper.validateConfigurationAttribute((Object)this.port, attr -> attr == null || attr < 1 || attr > 65535, () -> String.format("Resource %s - Invalid port configured for protocol %s. Port value returned: %s. This resource will not be monitored. Please verify the configured port value.", resourceKey, displayName, this.port));
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, displayName, this.timeout));
        StringHelper.validateConfigurationAttribute((Object)this.retryIntervals, attr -> Objects.nonNull(attr) && Arrays.stream(attr).allMatch(value -> value < 1), () -> String.format("Resource %s - retryIntervals value is invalid for protocol %s. retryIntervals value returned: %s. This resource will not be monitored. Please verify the configured retryIntervals value.", resourceKey, displayName, this.retryIntervals));
    }

    @Override
    public int getIntVersion() {
        return this.version.intVersion;
    }

    public IConfiguration copy() {
        return SnmpConfiguration.builder().community(this.community).port(this.port).timeout(this.timeout).retryIntervals(this.retryIntervals).version(this.version).hostname(this.hostname).build();
    }

    @Generated
    private static SnmpVersion $default$version() {
        return SnmpVersion.V1;
    }

    @Generated
    private static char[] $default$community() {
        return new char[]{'p', 'u', 'b', 'l', 'i', 'c'};
    }

    @Generated
    private static Integer $default$port() {
        return 161;
    }

    @Generated
    private static Long $default$timeout() {
        return 120L;
    }

    @Generated
    public static SnmpConfigurationBuilder builder() {
        return new SnmpConfigurationBuilder();
    }

    @Generated
    public SnmpVersion getVersion() {
        return this.version;
    }

    @Generated
    public char[] getCommunity() {
        return this.community;
    }

    @Override
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public int[] getRetryIntervals() {
        return this.retryIntervals;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setCommunity(char[] community) {
        this.community = community;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setRetryIntervals(int[] retryIntervals) {
        this.retryIntervals = retryIntervals;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpConfiguration)) {
            return false;
        }
        SnmpConfiguration other = (SnmpConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        SnmpVersion this$version = this.getVersion();
        SnmpVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version)) {
            return false;
        }
        if (!Arrays.equals(this.getCommunity(), other.getCommunity())) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        return Arrays.equals(this.getRetryIntervals(), other.getRetryIntervals());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        SnmpVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getCommunity());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        result = result * 59 + Arrays.hashCode(this.getRetryIntervals());
        return result;
    }

    @Generated
    public SnmpConfiguration(SnmpVersion version, char[] community, Integer port, Long timeout, String hostname, int[] retryIntervals) {
        this.version = version;
        this.community = community;
        this.port = port;
        this.timeout = timeout;
        this.hostname = hostname;
        this.retryIntervals = retryIntervals;
    }

    @Generated
    public SnmpConfiguration() {
        this.version = SnmpConfiguration.$default$version();
        this.community = SnmpConfiguration.$default$community();
        this.port = SnmpConfiguration.$default$port();
        this.timeout = SnmpConfiguration.$default$timeout();
    }

    public static enum SnmpVersion {
        V1(1, "SNMP v1"),
        V2C(2, "SNMP v2c");

        private final int intVersion;
        private final String displayName;

        public static SnmpVersion interpretValueOf(@NonNull String version) {
            if (version == null) {
                throw new IllegalArgumentException("version is marked non-null but is null");
            }
            String lowerCaseVersion = version.toLowerCase();
            if ("1".equals(lowerCaseVersion) || "v1".equals(lowerCaseVersion)) {
                return V1;
            }
            if ("2".equals(lowerCaseVersion) || "v2".equals(lowerCaseVersion) || "v2c".equals(lowerCaseVersion) || "2c".equals(lowerCaseVersion)) {
                return V2C;
            }
            throw new IllegalArgumentException(SnmpConfiguration.INVALID_SNMP_VERSION_EXCEPTION_MESSAGE + version);
        }

        @Generated
        private SnmpVersion(int intVersion, String displayName) {
            this.intVersion = intVersion;
            this.displayName = displayName;
        }

        @Generated
        public int getIntVersion() {
            return this.intVersion;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }
    }

    @Generated
    public static class SnmpConfigurationBuilder {
        @Generated
        private boolean version$set;
        @Generated
        private SnmpVersion version$value;
        @Generated
        private boolean community$set;
        @Generated
        private char[] community$value;
        @Generated
        private boolean port$set;
        @Generated
        private Integer port$value;
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;
        @Generated
        private String hostname;
        @Generated
        private int[] retryIntervals;

        @Generated
        SnmpConfigurationBuilder() {
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=SnmpVersionDeserializer.class)
        @Generated
        public SnmpConfigurationBuilder version(SnmpVersion version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public SnmpConfigurationBuilder community(char[] community) {
            this.community$value = community;
            this.community$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public SnmpConfigurationBuilder port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public SnmpConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MultiValueDeserializer.class)
        @Generated
        public SnmpConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public SnmpConfigurationBuilder retryIntervals(int[] retryIntervals) {
            this.retryIntervals = retryIntervals;
            return this;
        }

        @Generated
        public SnmpConfiguration build() {
            SnmpVersion version$value = this.version$value;
            if (!this.version$set) {
                version$value = SnmpConfiguration.$default$version();
            }
            char[] community$value = this.community$value;
            if (!this.community$set) {
                community$value = SnmpConfiguration.$default$community();
            }
            Integer port$value = this.port$value;
            if (!this.port$set) {
                port$value = SnmpConfiguration.$default$port();
            }
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = SnmpConfiguration.$default$timeout();
            }
            return new SnmpConfiguration(version$value, community$value, port$value, timeout$value, this.hostname, this.retryIntervals);
        }

        @Generated
        public String toString() {
            return "SnmpConfiguration.SnmpConfigurationBuilder(version$value=" + String.valueOf((Object)this.version$value) + ", community$value=" + Arrays.toString(this.community$value) + ", port$value=" + this.port$value + ", timeout$value=" + this.timeout$value + ", hostname=" + this.hostname + ", retryIntervals=" + Arrays.toString(this.retryIntervals) + ")";
        }
    }
}

