/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmp;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpExtension;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpRequestExecutor;
import org.sentrysoftware.metricshub.extension.snmp.SnmpConfiguration;
import org.sentrysoftware.metricshub.extension.snmp.SnmpRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpExtension
extends AbstractSnmpExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnmpExtension.class);
    private static final String IDENTIFIER = "snmp";
    @NonNull
    private SnmpRequestExecutor snmpRequestExecutor;

    public SnmpExtension() {
        this.snmpRequestExecutor = new SnmpRequestExecutor();
    }

    public boolean isValidConfiguration(IConfiguration configuration) {
        return configuration instanceof SnmpConfiguration;
    }

    protected Class<SnmpConfiguration> getConfigurationClass() {
        return SnmpConfiguration.class;
    }

    public IConfiguration buildConfiguration(@NonNull String configurationType, @NonNull JsonNode jsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        if (configurationType == null) {
            throw new IllegalArgumentException("configurationType is marked non-null but is null");
        }
        if (jsonNode == null) {
            throw new IllegalArgumentException("jsonNode is marked non-null but is null");
        }
        try {
            char[] community;
            SnmpConfiguration snmpConfiguration = (SnmpConfiguration)SnmpExtension.newObjectMapper().treeToValue((TreeNode)jsonNode, SnmpConfiguration.class);
            if (decrypt != null && (community = snmpConfiguration.getCommunity()) != null) {
                snmpConfiguration.setCommunity((char[])decrypt.apply(community));
            }
            return snmpConfiguration;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error while reading SNMP Configuration. Error: %s", e.getMessage());
            log.error(errorMessage);
            log.debug("Error while reading SNMP Configuration. Stack trace:", (Throwable)e);
            throw new InvalidConfigurationException(errorMessage, (Throwable)e);
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public AbstractSnmpRequestExecutor getRequestExecutor() {
        return this.snmpRequestExecutor;
    }

    @Generated
    public SnmpExtension(@NonNull SnmpRequestExecutor snmpRequestExecutor) {
        if (snmpRequestExecutor == null) {
            throw new IllegalArgumentException("snmpRequestExecutor is marked non-null but is null");
        }
        this.snmpRequestExecutor = snmpRequestExecutor;
    }
}

