/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.snmp.detection;

import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.snmp.AbstractSnmpRequestExecutor;
import org.sentrysoftware.metricshub.extension.snmp.ISnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpGetCriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnmpGetCriterionProcessor.class);
    @NonNull
    private AbstractSnmpRequestExecutor snmpRequestExecutor;
    @NonNull
    private Function<TelemetryManager, ISnmpConfiguration> configurationRetriever;

    public CriterionTestResult process(SnmpGetCriterion snmpGetCriterion, String connectorId, TelemetryManager telemetryManager) {
        if (snmpGetCriterion == null) {
            log.error("Hostname {} - Malformed SNMP Get criterion {}. Cannot process SNMP Get detection. Connector ID: {}.", new Object[]{telemetryManager.getHostname(), snmpGetCriterion, connectorId});
            return CriterionTestResult.empty();
        }
        ISnmpConfiguration snmpConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (snmpConfiguration == null) {
            log.debug("Hostname {} - The SNMP credentials are not configured. Cannot process SNMP Get criterion {}. Connector ID: {}.", new Object[]{telemetryManager.getHostname(), snmpGetCriterion, connectorId});
            return CriterionTestResult.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(snmpConfiguration.getClass()));
        try {
            String result = this.snmpRequestExecutor.executeSNMPGet(snmpGetCriterion.getOid(), snmpConfiguration, hostname, false);
            CriterionTestResult criterionTestResult = SnmpGetCriterionProcessor.checkSNMPGetResult(hostname, snmpGetCriterion.getOid(), snmpGetCriterion.getExpectedResult(), result);
            criterionTestResult.setResult(result);
            return criterionTestResult;
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - SNMP test failed - SNMP Get of %s was unsuccessful due to an exception. Message: %s. Connector ID: %s.", hostname, snmpGetCriterion.getOid(), e.getMessage(), connectorId);
            log.debug(message, (Throwable)e);
            return CriterionTestResult.builder().message(message).build();
        }
    }

    static CriterionTestResult checkSNMPGetValue(String hostname, String oid, String result) {
        String message;
        boolean success = false;
        if (result == null) {
            message = String.format("Hostname %s - SNMP test failed - SNMP Get of %s was unsuccessful due to a null result", hostname, oid);
        } else if (result.isBlank()) {
            message = String.format("Hostname %s - SNMP test failed - SNMP Get of %s was unsuccessful due to an empty result.", hostname, oid);
        } else {
            message = String.format("Hostname %s - Successful SNMP Get of %s. Returned result: %s.", hostname, oid, result);
            success = true;
        }
        log.debug(message);
        return CriterionTestResult.builder().message(message).success(success).build();
    }

    static CriterionTestResult checkSNMPGetResult(String hostname, String oid, String expected, String result) {
        if (expected == null) {
            return SnmpGetCriterionProcessor.checkSNMPGetValue(hostname, oid, result);
        }
        return SnmpGetCriterionProcessor.checkSNMPGetExpectedValue(hostname, oid, expected, result);
    }

    static CriterionTestResult checkSNMPGetExpectedValue(String hostname, String oid, String expected, String result) {
        Object message;
        boolean success = false;
        Pattern pattern = Pattern.compile(PslUtils.psl2JavaRegex((String)expected), 10);
        if (result == null || !pattern.matcher(result).find()) {
            message = String.format("Hostname %s - SNMP test failed - SNMP Get of %s was successful but the value of the returned OID did not match with the expected result. ", hostname, oid);
            message = (String)message + String.format("Expected value: %s - returned value %s.", expected, result);
        } else {
            message = String.format("Hostname %s - Successful SNMP Get of %s. Returned result: %s", hostname, oid, result);
            success = true;
        }
        log.debug((String)message);
        return CriterionTestResult.builder().message((String)message).success(success).build();
    }

    @Generated
    public SnmpGetCriterionProcessor(@NonNull AbstractSnmpRequestExecutor snmpRequestExecutor, @NonNull Function<TelemetryManager, ISnmpConfiguration> configurationRetriever) {
        if (snmpRequestExecutor == null) {
            throw new IllegalArgumentException("snmpRequestExecutor is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        this.snmpRequestExecutor = snmpRequestExecutor;
        this.configurationRetriever = configurationRetriever;
    }
}

