/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.snmp.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sentrysoftware.snmp.client.SnmpResult;
import uk.co.westhawk.snmp.pdu.BlockPdu;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextv2c;
import uk.co.westhawk.snmp.stack.SnmpContextv3;
import uk.co.westhawk.snmp.stack.varbind;

public class SnmpClient {
    public static final int SNMP_PORT = 161;
    public static final int SNMP_V1 = 1;
    public static final int SNMP_V2C = 2;
    public static final int SNMP_V3 = 3;
    public static final String SNMP_AUTH_MD5 = "MD5";
    public static final String SNMP_AUTH_SHA = "SHA";
    public static final String SNMP_PRIVACY_DES = "DES";
    public static final String SNMP_PRIVACY_AES = "AES";
    public static final String SNMP_NONE = "None";
    private SnmpContext contextv1 = null;
    private SnmpContextv2c contextv2c = null;
    private SnmpContextv3 contextv3 = null;
    private BlockPdu pdu;
    private String host;
    private int port;
    private String community;
    private int snmpVersion;
    private String authUsername;
    private String authType;
    private String authPassword;
    private String privacyType;
    private String privacyPassword;
    private int[] retryIntervals;
    private String contextName;
    private byte[] contextEngineID;
    public static final String SOCKET_TYPE = "Standard";

    public SnmpClient(String host, int port, int version, int[] retryIntervals, String community, String authType, String authUsername, String authPassword, String privacyType, String privacyPassword, String contextName, byte[] contextID) throws IOException {
        this.validate(version, authType, privacyType);
        this.host = host;
        this.port = port;
        this.snmpVersion = version;
        this.retryIntervals = retryIntervals;
        this.community = community;
        this.authType = authType;
        this.authUsername = authUsername;
        this.authPassword = authPassword;
        this.privacyType = privacyType;
        this.privacyPassword = privacyPassword;
        this.contextName = contextName;
        this.contextEngineID = contextID;
        this.initialize();
    }

    private void validate(int version, String authType, String privacyType) {
        if (version == 3) {
            if (!(authType == null || authType.isEmpty() || authType.equals(SNMP_AUTH_MD5) || authType.equals(SNMP_AUTH_SHA))) {
                throw new IllegalArgumentException("Invalid authentication method '" + authType + "' (must be either '" + SNMP_AUTH_MD5 + "' or '" + SNMP_AUTH_SHA + "' or empty)");
            }
            if (!(privacyType == null || privacyType.isEmpty() || privacyType.equals(SNMP_PRIVACY_DES) || privacyType.equals(SNMP_PRIVACY_AES))) {
                throw new IllegalArgumentException("Invalid privacy method '" + privacyType + "' (must be either '" + SNMP_PRIVACY_DES + "' or '" + SNMP_PRIVACY_AES + "' or empty)");
            }
        }
    }

    private void initialize() throws IOException {
        if (this.snmpVersion == 2) {
            this.contextv2c = new SnmpContextv2c(this.host, this.port, null, SOCKET_TYPE);
            this.contextv2c.setCommunity(this.community);
        } else if (this.snmpVersion == 3) {
            int authProtocolCode = 0;
            int privacyProtocolCode = 0;
            boolean authenticate = false;
            boolean privacy = false;
            if (this.contextEngineID == null) {
                this.contextEngineID = new byte[0];
            }
            if (this.contextName == null) {
                this.contextName = "";
            }
            if (this.authUsername == null) {
                this.authUsername = "";
            }
            if (this.authType == null || this.authUsername == null || this.authPassword == null) {
                authenticate = false;
                authProtocolCode = 4;
                this.authPassword = "";
            } else if (this.authType.isEmpty() || this.authUsername.isEmpty() || this.authPassword.isEmpty()) {
                authenticate = false;
                authProtocolCode = 4;
                this.authPassword = "";
            } else if (this.authType.equals(SNMP_AUTH_MD5)) {
                authenticate = true;
                authProtocolCode = 0;
            } else if (this.authType.equals(SNMP_AUTH_SHA)) {
                authenticate = true;
                authProtocolCode = 1;
            }
            if (this.privacyType == null || this.privacyPassword == null) {
                privacy = false;
            } else if (this.privacyType.isEmpty() || this.privacyPassword.isEmpty()) {
                privacy = false;
            } else if (this.privacyType.equals(SNMP_PRIVACY_DES)) {
                privacy = true;
                privacyProtocolCode = 2;
            } else if (this.privacyType.equals(SNMP_PRIVACY_AES)) {
                privacy = true;
                privacyProtocolCode = 3;
            }
            if (privacy && !authenticate) {
                throw new IllegalStateException("Authentication is required for privacy to be enforced");
            }
            this.contextv3 = new SnmpContextv3(this.host, this.port, SOCKET_TYPE);
            this.contextv3.setContextEngineId(this.contextEngineID);
            this.contextv3.setContextName(this.contextName);
            this.contextv3.setUserName(this.authUsername);
            this.contextv3.setUseAuthentication(authenticate);
            if (authenticate) {
                this.contextv3.setUserAuthenticationPassword(this.authPassword);
                this.contextv3.setAuthenticationProtocol(authProtocolCode);
                this.contextv3.setUsePrivacy(privacy);
                if (privacy) {
                    this.contextv3.setPrivacyProtocol(privacyProtocolCode);
                    this.contextv3.setUserPrivacyPassword(this.privacyPassword);
                }
            }
        } else {
            this.contextv1 = new SnmpContext(this.host, this.port, SOCKET_TYPE);
            this.contextv1.setCommunity(this.community);
        }
        AsnOctets.setHexPrefix("");
    }

    public void freeResources() {
        if (this.contextv1 != null) {
            this.contextv1.destroy();
            this.contextv1 = null;
        }
        if (this.contextv2c != null) {
            this.contextv2c.destroy();
            this.contextv2c = null;
        }
        if (this.contextv3 != null) {
            this.contextv3.destroy();
            this.contextv3 = null;
        }
        if (this.pdu != null) {
            this.pdu = null;
        }
    }

    private void createPdu() {
        this.pdu = this.snmpVersion == 2 ? new BlockPdu(this.contextv2c) : (this.snmpVersion == 3 ? new BlockPdu(this.contextv3) : new BlockPdu(this.contextv1));
        if (this.retryIntervals != null) {
            this.pdu.setRetryIntervals(this.retryIntervals);
        }
    }

    public String get(String oid) throws Exception {
        this.createPdu();
        this.pdu.setPduType(0);
        this.pdu.addOid(oid);
        return this.sendRequest().value;
    }

    public String getWithDetails(String oid) throws Exception {
        this.createPdu();
        this.pdu.setPduType(0);
        this.pdu.addOid(oid);
        SnmpResult result = this.sendRequest();
        return result.oid + "\t" + result.type + "\t" + result.value;
    }

    public String getNext(String oid) throws Exception {
        this.createPdu();
        this.pdu.setPduType(2);
        this.pdu.addOid(oid);
        SnmpResult result = this.sendRequest();
        return result.oid + "\t" + result.type + "\t" + result.value;
    }

    public String walk(String oid) throws Exception {
        StringBuilder walkResult = new StringBuilder();
        if (oid == null) {
            throw new IllegalArgumentException("Invalid SNMP Walk OID: null");
        }
        if (oid.length() < 3) {
            throw new IllegalArgumentException("Invalid SNMP Walk OID: \"" + oid + "\"");
        }
        this.getNext(oid);
        String currentOID = oid;
        do {
            SnmpResult getNextResult;
            this.createPdu();
            this.pdu.setPduType(2);
            this.pdu.addOid(currentOID);
            try {
                getNextResult = this.sendRequest();
            }
            catch (Exception e) {
                break;
            }
            currentOID = getNextResult.oid;
            if (!currentOID.startsWith(oid)) break;
            walkResult.append(currentOID + "\t" + getNextResult.type + "\t" + getNextResult.value + "\n");
        } while (walkResult.length() < 0xA00000);
        int resultLength = walkResult.length();
        if (resultLength > 0) {
            return walkResult.substring(0, resultLength - 1);
        }
        return "";
    }

    public List<List<String>> table(String rootOID, String[] selectColumnArray) throws Exception {
        if (rootOID == null) {
            throw new IllegalArgumentException("Invalid SNMP Table OID: null");
        }
        if (rootOID.length() < 3) {
            throw new IllegalArgumentException("Invalid SNMP Table OID: \"" + rootOID + "\"");
        }
        if (selectColumnArray == null) {
            throw new IllegalArgumentException("Invalid SNMP Table column numbers: null");
        }
        if (selectColumnArray.length < 1) {
            throw new IllegalArgumentException("Invalid SNMP Table column numbers: none");
        }
        this.createPdu();
        this.pdu.setPduType(2);
        this.pdu.addOid(rootOID);
        String firstValueOid = this.sendRequest().oid;
        if (firstValueOid.isEmpty() || !firstValueOid.startsWith(rootOID)) {
            return new ArrayList<List<String>>();
        }
        int tempIndex = firstValueOid.indexOf(".", rootOID.length() + 2);
        if (tempIndex < 0) {
            return new ArrayList<List<String>>();
        }
        String firstColumnOid = firstValueOid.substring(0, tempIndex);
        int firstColumnOidLength = firstColumnOid.length();
        ArrayList<String> IDArray = new ArrayList<String>(0);
        String currentOID = firstColumnOid;
        do {
            this.createPdu();
            this.pdu.setPduType(2);
            this.pdu.addOid(currentOID);
            SnmpResult getNextResult = this.sendRequest();
            currentOID = getNextResult.oid;
            if (!currentOID.startsWith(firstColumnOid)) break;
            IDArray.add(currentOID.substring(firstColumnOidLength + 1));
        } while (IDArray.size() < 10000);
        ArrayList<List<String>> tableResult = new ArrayList<List<String>>();
        for (String ID : IDArray) {
            ArrayList<String> row = new ArrayList<String>();
            for (String column : selectColumnArray) {
                if (column.equals("ID")) {
                    row.add(ID);
                    continue;
                }
                try {
                    row.add(this.get(rootOID + "." + column + "." + ID));
                }
                catch (Exception e) {
                    row.add("");
                }
            }
            tableResult.add(row);
        }
        return tableResult;
    }

    private SnmpResult sendRequest() throws PduException, IOException, Exception {
        SnmpResult result = new SnmpResult();
        varbind var = this.pdu.getResponseVariableBinding();
        AsnObjectId oid = var.getOid();
        AsnObject value = var.getValue();
        byte valueType = value.getRespType();
        if (valueType == -128 || valueType == -127 || valueType == -126) {
            throw new Exception(value.getRespTypeString());
        }
        if (valueType == 5) {
            result.oid = oid.toString();
            result.type = "null";
        } else if (valueType == 4) {
            result.oid = oid.toString();
            result.type = "ASN_OCTET_STR";
            AsnOctets octetStringValue = (AsnOctets)value;
            String octetStringValuetoString = octetStringValue.toString();
            String octetStringValuetoHex = octetStringValue.toHex().replace(':', ' ');
            result.value = octetStringValuetoString.isEmpty() && octetStringValue.getBytes().length > 0 ? octetStringValuetoHex : (octetStringValuetoString.length() == octetStringValuetoHex.length() ? octetStringValuetoHex : octetStringValuetoString);
        } else {
            result.oid = oid.toString();
            result.type = value.getRespTypeString();
            result.value = value.toString();
        }
        return result;
    }
}

