/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.westhawk.snmp.stack.AsnDecoderBase;
import uk.co.westhawk.snmp.stack.AsnEncoderv3;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.SnmpContextv3Basis;
import uk.co.westhawk.snmp.stack.TimeWindow;
import uk.co.westhawk.snmp.stack.usmStatsConstants;
import uk.co.westhawk.snmp.stack.varbind;
import uk.co.westhawk.snmp.util.SnmpUtilities;

class AsnDecoderv3
extends AsnDecoderBase
implements usmStatsConstants {
    private static final String version_id = "@(#)$Id: AsnDecoderv3.java,v 3.9 2009/03/05 12:48:59 birgita Exp $ Copyright Westhawk Ltd";

    AsnDecoderv3() {
    }

    int getMsgId(AsnSequence asnTopSeq) throws DecodingException {
        int msgId = -1;
        AsnSequence asnHeaderData = this.getAsnHeaderData(asnTopSeq);
        AsnObject obj = asnHeaderData.getObj(0);
        if (!(obj instanceof AsnInteger)) {
            String msg = "msgId should be of type AsnInteger instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        AsnInteger value = (AsnInteger)obj;
        msgId = value.getValue();
        return msgId;
    }

    AsnSequence DecodeSNMPv3(InputStream in) throws IOException, DecodingException {
        AsnSequence asnTopSeq = this.getAsnSequence(in);
        int snmpVersion = this.getSNMPVersion(asnTopSeq);
        if (snmpVersion != 3) {
            String str = SnmpUtilities.getSnmpVersionString(snmpVersion);
            String msg = "Wrong SNMP version: expected SNMPv3, received " + str;
            throw new DecodingException(msg);
        }
        int securityModel = -1;
        AsnSequence asnHeaderData = this.getAsnHeaderData(asnTopSeq);
        AsnObject obj = asnHeaderData.getObj(3);
        if (obj instanceof AsnInteger) {
            AsnInteger value = (AsnInteger)obj;
            securityModel = value.getValue();
            if (securityModel != 3) {
                String msg = "Wrong v3 Security Model: expected USM(3), received " + securityModel;
                throw new DecodingException(msg);
            }
        } else {
            String msg = "securityModel should be of type AsnInteger instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        return asnTopSeq;
    }

    AsnPduSequence processSNMPv3(SnmpContextv3Basis context, AsnSequence asnTopSeq, byte[] message, boolean amIAuthoritative) throws IOException, DecodingException {
        AsnPduSequence pduSeq = null;
        boolean isCorrect = asnTopSeq.isCorrect;
        AsnSequence asnHeaderData = this.getAsnHeaderData(asnTopSeq);
        byte[] msgFlags = ((AsnOctets)asnHeaderData.getObj(2)).getBytes();
        boolean isUseAuthentication = this.isUseAuthentication(msgFlags[0]);
        boolean isUsePrivacy = this.isUsePrivacy(msgFlags[0]);
        AsnOctets asnSecurityParameters = (AsnOctets)asnTopSeq.getObj(2);
        AsnSequence usmObject = this.decodeUSM(asnSecurityParameters);
        byte[] engineIdBytes = ((AsnOctets)usmObject.getObj(0)).getBytes();
        String engineId = SnmpUtilities.toHexString(engineIdBytes);
        int boots = ((AsnInteger)usmObject.getObj(1)).getValue();
        int time = ((AsnInteger)usmObject.getObj(2)).getValue();
        String userName = ((AsnOctets)usmObject.getObj(3)).getValue();
        AsnOctets realFingerPrintObject = (AsnOctets)usmObject.getObj(4);
        byte[] realFingerPrint = realFingerPrintObject.getBytes();
        byte[] salt = ((AsnOctets)usmObject.getObj(5)).getBytes();
        TimeWindow tWindow = TimeWindow.getCurrent();
        if (!amIAuthoritative) {
            String storedEngineId;
            String receivedFromHostAddress;
            if (engineId.length() > 0 && !tWindow.isEngineIdOK(context.getReceivedFromHostAddress(), context.getPort(), engineId)) {
                String msg = "Received engine Id ('" + engineId + "') is not correct.";
                msg = msg + " amIAuthoritative == false";
                throw new DecodingException(msg);
            }
            String sendToHostAddress = context.getSendToHostAddress();
            if (!sendToHostAddress.equals(receivedFromHostAddress = context.getReceivedFromHostAddress()) && (storedEngineId = tWindow.getSnmpEngineId(sendToHostAddress, context.getPort())) == null) {
                tWindow.setSnmpEngineId(sendToHostAddress, context.getPort(), "00");
            }
        } else if (engineId.length() > 0) {
            context.getUsmAgent();
            if (!tWindow.isEngineIdOK("_myusmagent", context.getPort(), engineId)) {
                String msg = "Received engine Id ('" + engineId + "') is not correct.";
                msg = msg + " amIAuthoritative == true";
                throw new DecodingException(msg);
            }
        }
        if (!userName.equals(context.getUserName())) {
            String msg = "Received userName ('" + userName + "') is not correct";
            throw new DecodingException(msg);
        }
        DecodingException encryptionDecodingException = null;
        IOException encryptionIOException = null;
        try {
            AsnObject asnScopedObject = asnTopSeq.getObj(3);
            AsnSequence asnPlainScopedPdu = null;
            if (isUsePrivacy) {
                byte[] passwKey;
                byte[] privKey = null;
                int prot = context.getAuthenticationProtocol();
                if (prot == 0) {
                    passwKey = context.getPrivacyPasswordKeyMD5();
                    privKey = SnmpUtilities.getLocalizedKeyMD5(passwKey, engineId);
                } else {
                    passwKey = context.getPrivacyPasswordKeySHA1();
                    privKey = SnmpUtilities.getLocalizedKeySHA1(passwKey, engineId);
                }
                AsnOctets asnEncryptedScopedPdu = (AsnOctets)asnScopedObject;
                byte[] encryptedText = asnEncryptedScopedPdu.getBytes();
                byte[] plainText = null;
                int pprot = context.getPrivacyProtocol();
                plainText = pprot == 3 ? SnmpUtilities.AESdecrypt(encryptedText, privKey, boots, time, salt) : SnmpUtilities.DESdecrypt(encryptedText, salt, privKey);
                if (AsnObject.debug > 10) {
                    System.out.println("Encrypted PDU: ");
                    System.out.println("Decoding with : " + SnmpContextv3Basis.ProtocolNames[pprot]);
                }
                ByteArrayInputStream plainIn = new ByteArrayInputStream(plainText);
                asnPlainScopedPdu = this.getAsnSequence(plainIn);
            } else {
                asnPlainScopedPdu = (AsnSequence)asnScopedObject;
            }
            byte[] contextId = ((AsnOctets)asnPlainScopedPdu.getObj(0)).getBytes();
            String contextName = ((AsnOctets)asnPlainScopedPdu.getObj(1)).getValue();
            pduSeq = (AsnPduSequence)asnPlainScopedPdu.findPdu();
        }
        catch (DecodingException exc) {
            encryptionDecodingException = exc;
        }
        catch (IOException exc) {
            encryptionIOException = exc;
        }
        if (pduSeq != null && engineId.length() == 0) {
            pduSeq.setSnmpv3Discovery(true);
        }
        boolean userIsUsingAuthentication = context.isUseAuthentication();
        if (isCorrect && isUseAuthentication != userIsUsingAuthentication) {
            String msg = "User " + userName + " does ";
            if (!userIsUsingAuthentication) {
                msg = msg + "not ";
            }
            msg = msg + "support authentication, but received message ";
            if (isUseAuthentication) {
                msg = msg + "with authentication.";
            } else {
                msg = msg + "without authentication";
                msg = msg + this.getUsmStats(pduSeq);
            }
            throw new DecodingException(msg);
        }
        boolean isAuthentic = false;
        if (isCorrect && isUseAuthentication) {
            String msg;
            byte[] authkey;
            byte[] passwKey;
            int fpPos = realFingerPrintObject.getContentsPos();
            if (AsnObject.debug > 10) {
                int fpLength = realFingerPrintObject.getContentsLength();
                String str = "Pos finger print = " + fpPos + ", len = " + fpLength;
                SnmpUtilities.dumpBytes(str, realFingerPrint);
            }
            byte[] calcFingerPrint = null;
            System.arraycopy(AsnEncoderv3.dummyFingerPrint, 0, message, fpPos, realFingerPrint.length);
            int prot = context.getAuthenticationProtocol();
            if (prot == 0) {
                passwKey = context.getAuthenticationPasswordKeyMD5();
                authkey = SnmpUtilities.getLocalizedKeyMD5(passwKey, engineId);
                calcFingerPrint = SnmpUtilities.getFingerPrintMD5(authkey, message);
            } else {
                passwKey = context.getAuthenticationPasswordKeySHA1();
                authkey = SnmpUtilities.getLocalizedKeySHA1(passwKey, engineId);
                calcFingerPrint = SnmpUtilities.getFingerPrintSHA1(authkey, message);
            }
            if (!SnmpUtilities.areBytesEqual(realFingerPrint, calcFingerPrint)) {
                msg = "Authentication comparison failed";
                throw new DecodingException(msg);
            }
            if (pduSeq != null && boots == 0 && time == 0) {
                pduSeq.setSnmpv3Discovery(true);
            }
            if (tWindow.isOutsideTimeWindow(engineId, boots, time)) {
                msg = "Message is outside time window";
                throw new DecodingException(msg);
            }
            isAuthentic = true;
        }
        tWindow.updateTimeWindow(engineId, boots, time, isAuthentic);
        boolean userIsUsingPrivacy = context.isUsePrivacy();
        if (isCorrect && isUsePrivacy != userIsUsingPrivacy) {
            String msg = "User " + userName + " does ";
            if (!userIsUsingPrivacy) {
                msg = msg + "not ";
            }
            msg = msg + "support privacy, but received message ";
            if (isUsePrivacy) {
                msg = msg + "with privacy.";
            } else {
                msg = msg + "without privacy";
                msg = msg + this.getUsmStats(pduSeq);
            }
            throw new DecodingException(msg);
        }
        if (encryptionDecodingException != null) {
            throw encryptionDecodingException;
        }
        if (encryptionIOException != null) {
            throw encryptionIOException;
        }
        if (pduSeq != null && !isCorrect) {
            pduSeq.isCorrect = false;
        }
        return pduSeq;
    }

    private boolean isUseAuthentication(byte msgFlags) {
        boolean isUseAuthentication = (1 & msgFlags) > 0;
        return isUseAuthentication;
    }

    private boolean isUsePrivacy(byte msgFlags) {
        boolean isUsePrivacy = (2 & msgFlags) > 0;
        return isUsePrivacy;
    }

    private AsnSequence decodeUSM(AsnOctets asnSecurityParameters) throws IOException {
        byte[] usmBytes = asnSecurityParameters.getBytes();
        if (AsnObject.debug > 10) {
            SnmpUtilities.dumpBytes("Decoding USM:", usmBytes);
        }
        ByteArrayInputStream usmIn = new ByteArrayInputStream(usmBytes);
        AsnSequence usmOctets = new AsnSequence(usmIn, usmBytes.length, asnSecurityParameters.getContentsPos());
        AsnSequence usmObject = (AsnSequence)usmOctets.getObj(0);
        return usmObject;
    }

    private String getUsmStats(AsnPduSequence pduSeq) {
        String msg = "";
        AsnSequence varBind = (AsnSequence)pduSeq.getObj(3);
        int size = varBind.getObjCount();
        if (size > 0) {
            int i;
            AsnSequence varSeq = (AsnSequence)varBind.getObj(0);
            varbind vb = new varbind(varSeq);
            AsnObjectId oid = vb.getOid();
            boolean found = false;
            for (i = 0; i < usmStatsOids.length && !found; ++i) {
                AsnObjectId usmOid = new AsnObjectId(usmStatsOids[i]);
                found = oid.startsWith(usmOid);
            }
            msg = found ? msg + ": " + usmStatsStrings[--i] + " " + vb.getValue() : msg + ": " + vb;
        }
        return msg;
    }
}

