/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandConfiguration;

public class SshConfiguration
extends OsCommandConfiguration {
    public static final int DEFAULT_PORT = 22;
    private String username;
    private char[] password;
    private String privateKey;
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer port = 22;

    public SshConfiguration(boolean useSudo, Set<String> useSudoCommands, String sudoCommand, Long timeout, Integer port, String username, char[] password, String privateKey, String hostname) {
        super(useSudo, useSudoCommands, sudoCommand, timeout, hostname);
        this.port = port == null ? 22 : port;
        this.username = username;
        this.password = password;
        this.privateKey = privateKey;
    }

    @Override
    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.username, attr -> attr == null || attr.isBlank(), () -> String.format("Resource %s - No username configured for protocol %s. This resource will not be monitored. Please verify the configured username.", resourceKey, "SSH"));
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, "SSH", this.timeout));
        StringHelper.validateConfigurationAttribute((Object)this.port, attr -> attr == null || attr < 0 || attr > 65535, () -> String.format("Resource %s - Port value is invalid for SSH protocol.", resourceKey));
    }

    @Override
    public String toString() {
        Object desc = "SSH";
        if (this.username != null) {
            desc = (String)desc + " as " + this.username;
        }
        return desc;
    }

    @Override
    public SshConfiguration copy() {
        return SshConfiguration.sshConfigurationBuilder().password(this.password).port(this.port).privateKey(this.privateKey).sudoCommand(this.sudoCommand).timeout(this.timeout).username(this.username).useSudo(this.useSudo).useSudoCommands(new HashSet<String>(this.useSudoCommands)).hostname(this.hostname).build();
    }

    @Generated
    public static SshConfigurationBuilder sshConfigurationBuilder() {
        return new SshConfigurationBuilder();
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SshConfiguration)) {
            return false;
        }
        SshConfiguration other = (SshConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SshConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        return result;
    }

    @Generated
    public SshConfiguration() {
    }

    @Generated
    public static class SshConfigurationBuilder {
        @Generated
        private boolean useSudo;
        @Generated
        private Set<String> useSudoCommands;
        @Generated
        private String sudoCommand;
        @Generated
        private Long timeout;
        @Generated
        private Integer port;
        @Generated
        private String username;
        @Generated
        private char[] password;
        @Generated
        private String privateKey;
        @Generated
        private String hostname;

        @Generated
        SshConfigurationBuilder() {
        }

        @Generated
        public SshConfigurationBuilder useSudo(boolean useSudo) {
            this.useSudo = useSudo;
            return this;
        }

        @Generated
        public SshConfigurationBuilder useSudoCommands(Set<String> useSudoCommands) {
            this.useSudoCommands = useSudoCommands;
            return this;
        }

        @Generated
        public SshConfigurationBuilder sudoCommand(String sudoCommand) {
            this.sudoCommand = sudoCommand;
            return this;
        }

        @Generated
        public SshConfigurationBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public SshConfigurationBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public SshConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public SshConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @Generated
        public SshConfigurationBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Generated
        public SshConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public SshConfiguration build() {
            return new SshConfiguration(this.useSudo, this.useSudoCommands, this.sudoCommand, this.timeout, this.port, this.username, this.password, this.privateKey, this.hostname);
        }

        @Generated
        public String toString() {
            return "SshConfiguration.SshConfigurationBuilder(useSudo=" + this.useSudo + ", useSudoCommands=" + String.valueOf(this.useSudoCommands) + ", sudoCommand=" + this.sudoCommand + ", timeout=" + this.timeout + ", port=" + this.port + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", privateKey=" + this.privateKey + ", hostname=" + this.hostname + ")";
        }
    }
}

