/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand.ipmi;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IpmiHelper {
    private static final Pattern PATTERN_BMC_REQ = Pattern.compile("(?m)^(BMC req|--).*");
    private static final String BOARD2 = " Board ";
    private static final String POOR_LIST = "poorList";
    private static final String GOOD_LIST = "goodList";
    private static final String ASSERTED = "=Asserted";
    private static final String DEVICE_ABSENT = "=Device Absent";
    private static final String FRU_LIST = "fruList";
    private static final String NOT_READING = "Not Reading";
    private static final String SENSOR_ID = "Sensor ID ";
    private static final String STATES_ASSERTED = "States Asserted";
    private static final String SENSOR_ID_REGEX = "^Sensor ID.*";
    private static final String OEM_SPECIFIC = "OEM Specific";
    private static final Pattern NUM_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final String STATE_DEASSERTED = "=State Deasserted";
    private static final String STATE_ASSERTED = "=State Asserted";
    private static final String EQUALS_0 = "=0";
    private static final String EQUALS_1 = "=1";
    private static final String DEASSERTED = "=Deasserted";
    private static final Pattern PATTERN_BTW_BRACKETS = Pattern.compile("\\((.*?)\\)");
    private static final Pattern PATTERN_SENSORID = Pattern.compile("^Sensor ID.*", 8);
    private static final Pattern PATTERN_ENTITYID = Pattern.compile("^ *Entity ID.*", 8);
    private static final Pattern PATTERN_SENSOR_READING = Pattern.compile("^ *Sensor Reading.*", 8);
    private static final Pattern PATTERN_THRESHOLD_UPPER_NON_CRITICAL = Pattern.compile(".*Upper non-critical.*", 8);
    private static final Pattern PATTERN_THRESHOLD_UPPER_CRITICAL = Pattern.compile(".*Upper critical.*", 8);
    private static final Pattern PATTERN_THRESHOLD_UPPER_NON_RECOVERABLE = Pattern.compile(".*Upper non-recoverable.*", 8);
    private static final Pattern PATTERN_THRESHOLD_LOWER_NON_CRITICAL = Pattern.compile(".*Lower non-critical.*", 8);
    private static final Pattern PATTERN_THRESHOLD_LOWER_CRITICAL = Pattern.compile(".*Lower critical.*", 8);
    private static final Pattern PATTERN_THRESHOLD_LOWER_NON_RECOVERABLE = Pattern.compile(".*Lower non-recoverable.*", 8);
    private static final Pattern PATTERN_OEM_SPECIFIC = Pattern.compile("States Asserted +: 0x[0-9a-zA-Z]+ +OEM Specific", 8);
    private static final Pattern PATTERN_FRUID = Pattern.compile("^FRU Device Description.*", 8);
    private static final Pattern PATTERN_VENDOR = Pattern.compile(" Product Manufacturer.*", 8);
    private static final Pattern PATTERN_MODEL = Pattern.compile(" Product Name.*", 8);
    private static final Pattern PATTERN_SERIAL = Pattern.compile(" Product Serial.*", 8);
    private static final Pattern PATTERN_BORD_VENDOR = Pattern.compile(" Board Mfg +:.*", 8);
    private static final Pattern PATTERN_BORD_MODEL = Pattern.compile(" Board Product.*", 8);
    private static final Pattern PATTERN_BORD_SERIAL = Pattern.compile(" Board Serial.*", 8);

    private IpmiHelper() {
    }

    public static List<List<String>> ipmiTranslateFromIpmitool(String fruResult, String sdrResult) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        sdrResult = IpmiHelper.cleanSensorCommandResult(sdrResult);
        List<String> ipmiTable = IpmiHelper.ipmiBuildDeviceListFromIpmitool(fruResult, sdrResult);
        ipmiTable = IpmiHelper.ipmiAddHardwareSensorInfo(sdrResult, ipmiTable);
        ipmiTable.forEach(line -> result.add(Stream.of(line.split(";")).collect(Collectors.toList())));
        return result;
    }

    public static String cleanSensorCommandResult(String sdrResult) {
        if (sdrResult == null || sdrResult.isEmpty()) {
            return sdrResult;
        }
        sdrResult = PATTERN_BMC_REQ.matcher(sdrResult).replaceAll("");
        sdrResult = sdrResult.replace(";", ",");
        sdrResult = sdrResult.replace("\n", ";");
        sdrResult = sdrResult.replace(";;", "\n");
        return sdrResult;
    }

    public static List<String> ipmiBuildDeviceListFromIpmitool(String fruResult, String sdrResult) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, List<String>> fruMap = IpmiHelper.processFruResult(fruResult);
        List<String> deviceList = new ArrayList<String>();
        deviceList = IpmiHelper.processSdrRecords(sdrResult, fruMap, deviceList);
        deviceList.removeIf(elt -> elt.contains(DEVICE_ABSENT));
        deviceList.replaceAll(elt -> elt.replace(STATE_ASSERTED, EQUALS_1));
        deviceList.replaceAll(elt -> elt.replace(STATE_DEASSERTED, EQUALS_0));
        deviceList.replaceAll(elt -> elt.replace(ASSERTED, EQUALS_1));
        deviceList.replaceAll(elt -> elt.replace(DEASSERTED, EQUALS_0));
        result.addAll((Collection)fruMap.get(GOOD_LIST));
        result.addAll((Collection)fruMap.get(POOR_LIST));
        result.addAll(deviceList);
        return result;
    }

    public static List<String> processSdrRecords(String sdrResult, Map<String, List<String>> fruMap, List<String> deviceList) {
        for (String sensor : sdrResult.split("\n")) {
            if (!sensor.startsWith(SENSOR_ID) || !sensor.contains(STATES_ASSERTED) || sensor.contains(NOT_READING)) continue;
            sensor = sensor.replace(";", "\n");
            String sensorName = IpmiHelper.checkPatternAndReturnDelimitedString(sensor, PATTERN_SENSORID, ":", "(");
            String entityId = IpmiHelper.checkPatternAndReturnDelimitedString(sensor, PATTERN_ENTITYID, ":", "(");
            if (entityId == null || entityId.isEmpty()) continue;
            String entityIdLine = IpmiHelper.checkPatternAndReturnDelimitedString(sensor, PATTERN_ENTITYID, "", "");
            String deviceType = IpmiHelper.checkPatternAndReturnDelimitedString(entityIdLine, PATTERN_BTW_BRACKETS, "", "").replace("(", "").replace(")", "");
            String deviceId = entityId.contains(".") ? entityId.split("\\.")[1] : "";
            String statusArray = IpmiHelper.getSensorStatusArray(sensor, sensorName);
            if (statusArray == null || statusArray.isEmpty() || statusArray.equals("|")) continue;
            deviceList = IpmiHelper.addSensorElementToDeviceList(deviceList, sdrResult, deviceType, deviceId, entityId, statusArray, fruMap.get(FRU_LIST));
        }
        return deviceList;
    }

    public static Map<String, List<String>> processFruResult(String fruResult) {
        ArrayList<String> goodFruList = new ArrayList<String>();
        ArrayList<String> poorFruList = new ArrayList<String>();
        ArrayList<CallSite> fruList = new ArrayList<CallSite>();
        HashMap<String, List<String>> ipmiTable = new HashMap<String, List<String>>();
        for (String fruEntry : fruResult.split("\n\n")) {
            boolean board = fruEntry.contains(BOARD2);
            String fruID = IpmiHelper.checkPatternAndReturnDelimitedString(fruEntry, PATTERN_FRUID, ":", "").trim();
            fruID = IpmiHelper.checkPatternAndReturnDelimitedString(fruID, PATTERN_BTW_BRACKETS, "(", ")").replace("ID ", "").trim();
            String fruVendor = IpmiHelper.checkPatternAndReturnDelimitedString(fruEntry, PATTERN_VENDOR, ":", "").trim();
            String fruModel = IpmiHelper.checkPatternAndReturnDelimitedString(fruEntry, PATTERN_MODEL, ":", "").trim();
            String fruSN = IpmiHelper.checkPatternAndReturnDelimitedString(fruEntry, PATTERN_SERIAL, ":", "").trim();
            String boardVendor = IpmiHelper.checkPatternAndReturnDelimitedString(fruEntry, PATTERN_BORD_VENDOR, ":", "").trim();
            String boardModel = IpmiHelper.checkPatternAndReturnDelimitedString(fruEntry, PATTERN_BORD_MODEL, ":", "").trim();
            String boardSN = IpmiHelper.checkPatternAndReturnDelimitedString(fruEntry, PATTERN_BORD_SERIAL, ":", "").trim();
            String fruEntryResult = String.format("FRU;%s;%s;%s", fruVendor, fruModel, fruSN);
            if (!board) {
                if (!fruModel.isEmpty() && !fruSN.isEmpty()) {
                    goodFruList.add(fruEntryResult);
                } else if (!fruVendor.isEmpty()) {
                    poorFruList.add(fruEntryResult);
                }
            } else if (!boardVendor.isEmpty()) {
                fruEntryResult = String.format("FRU;%s;%s;%s", boardVendor, boardModel, boardSN);
                poorFruList.add(fruEntryResult);
            }
            fruList.add((CallSite)((Object)(fruID + ";" + fruEntryResult)));
        }
        ipmiTable.put(GOOD_LIST, goodFruList);
        ipmiTable.put(POOR_LIST, poorFruList);
        ipmiTable.put(FRU_LIST, fruList);
        return ipmiTable;
    }

    public static List<String> ipmiAddHardwareSensorInfo(String sdrResult, List<String> ipmiTable) {
        block14: for (String sensorEntry : sdrResult.split("\n")) {
            String unit;
            String valueReading;
            String sensorReadingLine;
            sensorEntry = sensorEntry.replace(";", "\n");
            String sensorName = "";
            String sensorId = "";
            String entityId = "";
            String deviceType = "";
            String deviceId = "";
            String location = "";
            String sensorIdLine = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_SENSORID, "", "");
            if (sensorIdLine.isEmpty()) continue;
            sensorName = sensorIdLine.substring(sensorIdLine.indexOf(":") + 1, sensorIdLine.indexOf("(")).trim();
            Matcher matcher = PATTERN_BTW_BRACKETS.matcher(sensorIdLine);
            if (!matcher.find()) continue;
            sensorId = matcher.group(1).replace("0x", "");
            entityId = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_ENTITYID, ":", "(");
            String entityIdLine = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_ENTITYID, "", "");
            if (!entityIdLine.isEmpty() && entityIdLine.contains(":")) {
                matcher = PATTERN_BTW_BRACKETS.matcher(entityIdLine);
                if (matcher.find() && (deviceType = matcher.group(1)).contains("(")) {
                    deviceType = deviceType.substring(0, deviceType.indexOf("(")).trim();
                }
                if (entityId.contains(".")) {
                    deviceId = entityId.split("\\.")[1];
                }
                location = String.format("%s %s", deviceType, deviceId);
            }
            if ((sensorReadingLine = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_SENSOR_READING, "", "")).isEmpty() || !sensorReadingLine.contains("(") || !NUM_PATTERN.matcher(valueReading = sensorReadingLine.substring(sensorReadingLine.indexOf(":") + 1, sensorReadingLine.indexOf("(")).trim()).matches()) continue;
            switch (unit = sensorReadingLine.substring(sensorReadingLine.indexOf(")") + 1).trim()) {
                case "degrees C": {
                    String degreesResult = IpmiHelper.getTemperatureFromSensor(sensorEntry, sensorName, sensorId, location, valueReading);
                    ipmiTable.add(degreesResult);
                    continue block14;
                }
                case "RPM": {
                    String fanResult = IpmiHelper.getFanFromSensor(sensorEntry, sensorName, sensorId, location, valueReading);
                    ipmiTable.add(fanResult);
                    continue block14;
                }
                case "Volts": {
                    String voltageResult = IpmiHelper.getVoltageFromSensor(sensorEntry, sensorName, sensorId, location, valueReading);
                    ipmiTable.add(voltageResult);
                    continue block14;
                }
                case "Amps": {
                    ipmiTable.add(String.format("Current;%s;%s;%s;%s", sensorId, sensorName, location, valueReading));
                    continue block14;
                }
                case "Watts": {
                    ipmiTable.add(String.format("PowerConsumption;%s;%s;%s;%s", sensorId, sensorName, location, valueReading));
                    continue block14;
                }
            }
        }
        return ipmiTable;
    }

    public static String getVoltageFromSensor(String sensorEntry, String sensorName, String sensorId, String location, String valueReading) {
        String threshold2;
        String threshold1 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_LOWER_NON_CRITICAL, ":", "");
        if (!(!threshold1.isEmpty() && NUM_PATTERN.matcher(threshold1).matches() && Double.parseDouble(threshold1) != 0.0 || !(threshold1 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_LOWER_CRITICAL, ":", "")).isEmpty() && NUM_PATTERN.matcher(threshold1).matches() && Double.parseDouble(threshold1) != 0.0 || NUM_PATTERN.matcher(threshold1 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_LOWER_NON_RECOVERABLE, ":", "")).matches() && Double.parseDouble(threshold1) != 0.0)) {
            threshold1 = "";
        }
        if (!(!(threshold2 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_UPPER_NON_CRITICAL, ":", "")).isEmpty() && NUM_PATTERN.matcher(threshold2).matches() && Double.parseDouble(threshold2) != 0.0 || !(threshold2 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_UPPER_CRITICAL, ":", "")).isEmpty() && NUM_PATTERN.matcher(threshold2).matches() && Double.parseDouble(threshold2) != 0.0 || NUM_PATTERN.matcher(threshold2 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_UPPER_NON_RECOVERABLE, ":", "")).matches() && Double.parseDouble(threshold2) != 0.0)) {
            threshold2 = "";
        }
        if (NUM_PATTERN.matcher(threshold1).matches()) {
            threshold1 = Double.toString(Double.parseDouble(threshold1) * 1000.0);
        }
        if (NUM_PATTERN.matcher(threshold2).matches()) {
            threshold2 = Double.toString(Double.parseDouble(threshold2) * 1000.0);
        }
        if (NUM_PATTERN.matcher(valueReading).matches()) {
            valueReading = Double.toString(Double.parseDouble(valueReading) * 1000.0);
        }
        return String.format("Voltage;%s;%s;%s;%s;%s;%s", sensorId, sensorName, location, valueReading, threshold1, threshold2);
    }

    public static String getFanFromSensor(String sensorEntry, String sensorName, String sensorId, String location, String valueReading) {
        String threshold1 = "";
        Matcher matcherThreshold = PATTERN_THRESHOLD_LOWER_NON_CRITICAL.matcher(sensorEntry);
        if (matcherThreshold.find()) {
            threshold1 = matcherThreshold.group(0).trim();
            if (!NUM_PATTERN.matcher(threshold1 = threshold1.substring(threshold1.indexOf(":") + 1).trim()).matches()) {
                threshold1 = "";
            }
        }
        String threshold2 = "";
        matcherThreshold = PATTERN_THRESHOLD_LOWER_CRITICAL.matcher(sensorEntry);
        if (matcherThreshold.find()) {
            threshold2 = matcherThreshold.group(0).trim();
            threshold2 = threshold2.substring(threshold2.indexOf(":") + 1).trim();
        }
        if (!NUM_PATTERN.matcher(threshold2).matches()) {
            matcherThreshold = PATTERN_THRESHOLD_LOWER_NON_RECOVERABLE.matcher(sensorEntry);
            if (matcherThreshold.find()) {
                threshold2 = matcherThreshold.group(0).trim();
                threshold2 = threshold2.substring(threshold2.indexOf(":") + 1).trim();
            }
            if (!NUM_PATTERN.matcher(threshold2).matches()) {
                threshold2 = "";
            }
        }
        return String.format("Fan;%s;%s;%s;%s;%s;%s", sensorId, sensorName, location, valueReading, threshold1, threshold2);
    }

    public static String getTemperatureFromSensor(String sensorEntry, String sensorName, String sensorId, String location, String valueReading) {
        String threshold2;
        String threshold1 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_UPPER_NON_CRITICAL, ":", "");
        if (!NUM_PATTERN.matcher(threshold1).matches()) {
            threshold1 = "";
        }
        if (!NUM_PATTERN.matcher(threshold2 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_UPPER_CRITICAL, ":", "")).matches() && !NUM_PATTERN.matcher(threshold2 = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_THRESHOLD_UPPER_NON_RECOVERABLE, ":", "")).matches()) {
            threshold2 = "";
        }
        return String.format("Temperature;%s;%s;%s;%s;%s;%s", sensorId, sensorName, location, valueReading, threshold1, threshold2);
    }

    public static List<String> addSensorElementToDeviceList(List<String> deviceList, String sdrResult, String deviceType, String deviceId, String entityId, String statusArray, List<String> fruList) {
        String deviceElement = String.format(";%s %s;", deviceType, deviceId);
        Optional<String> matchedElt = deviceList.stream().filter(elt -> elt.contains(deviceElement)).findFirst();
        if (!matchedElt.isPresent()) {
            String vendor = "";
            String model = "";
            String serialNumber = "";
            Pattern p = Pattern.compile(";Entity ID +: " + Pattern.quote(entityId) + " .*;Logical FRU Device .*", 8);
            Matcher m = p.matcher(sdrResult);
            if (m.find()) {
                String fruDevice = m.group(0).replace(";", "\n");
                Optional<String> findFirstFruDevice = Arrays.stream(fruDevice.split("\n")).filter(role -> role.trim().startsWith("Logical FRU Device")).findFirst();
                String string = fruDevice = findFirstFruDevice.isPresent() ? findFirstFruDevice.get() : "";
                if (!fruDevice.isEmpty() && fruDevice.contains(":")) {
                    int fruId = Integer.parseInt(fruDevice.split(":")[1].trim().replace("h", ""), 16);
                    String elt2 = fruList.stream().filter(fru -> fru.startsWith(fruId + ";")).findFirst().orElse("");
                    if (!elt2.isEmpty()) {
                        String[] fruSplit = elt2.split(";");
                        vendor = fruSplit[1];
                        model = fruSplit[2];
                        serialNumber = fruSplit[3];
                    }
                }
            }
            deviceList.add(String.format("%s;%s;%s;%s;%s;%s;%s", deviceType, deviceId, String.format("%s %s", deviceType, deviceId), vendor, model, serialNumber, statusArray));
        } else {
            int index = deviceList.indexOf(matchedElt.get());
            deviceList.set(index, matchedElt.get() + "|" + statusArray);
        }
        return deviceList;
    }

    public static String getSensorStatusArray(String sensorEntry, String sensorName) {
        if (sensorName.isEmpty()) {
            sensorName = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, PATTERN_SENSORID, ";", "(");
        }
        StringBuilder statusArrayBuilder = new StringBuilder();
        String statusArray = "";
        if (sensorEntry.contains(STATES_ASSERTED) && sensorEntry.contains(OEM_SPECIFIC)) {
            statusArray = IpmiHelper.processOemSpecific(sensorName, sensorEntry);
        } else {
            if (!sensorEntry.contains("Assertions Enabled ")) {
                return null;
            }
            Pattern patternBtwBrackets = Pattern.compile("\\[(.*?)\\]");
            sensorEntry = sensorEntry.substring(0, sensorEntry.indexOf("Assertions Enabled "));
            Matcher matcher = patternBtwBrackets.matcher(sensorEntry);
            StringBuilder assertion = new StringBuilder();
            while (matcher.find()) {
                assertion.append("\n").append(matcher.group(1).trim());
            }
            statusArrayBuilder.append(sensorName).append("=").append(assertion.toString().trim().replaceAll("\n", "\n" + sensorName + "="));
            statusArray = statusArrayBuilder.toString().replaceAll("\n", "|");
        }
        return statusArray;
    }

    public static String processOemSpecific(String sensorName, String sensorEntry) {
        Matcher matcher;
        if (sensorName.isEmpty()) {
            Pattern patternSensorId = Pattern.compile(SENSOR_ID_REGEX, 8);
            sensorName = IpmiHelper.checkPatternAndReturnDelimitedString(sensorEntry, patternSensorId, ":", "(");
        }
        if ((matcher = PATTERN_OEM_SPECIFIC.matcher(sensorEntry)).find()) {
            String oemLine = matcher.group(0).trim();
            String oemSpecific = oemLine.split(": 0x")[1].trim().split("\\s")[0].trim();
            oemSpecific = Integer.toHexString(Integer.parseInt(oemSpecific, 16) | 0x8000);
            oemSpecific = String.format("%1$4s", oemSpecific).replace(' ', '0');
            return sensorName + "=0x" + oemSpecific;
        }
        return "";
    }

    public static String checkPatternAndReturnDelimitedString(String entry, Pattern patternToMatch, String leftLimit, String rightLimit) {
        boolean noRightLimit;
        Matcher matcher = patternToMatch.matcher(entry);
        boolean noLeftLimit = leftLimit == null || leftLimit.isEmpty();
        boolean bl = noRightLimit = rightLimit == null || rightLimit.isEmpty();
        if (matcher.find()) {
            String matchedLine = matcher.group(0).trim();
            if (noLeftLimit && noRightLimit) {
                return matchedLine;
            }
            if (!matchedLine.isEmpty()) {
                if (noRightLimit) {
                    return matchedLine.substring(matchedLine.indexOf(leftLimit) + 1).trim();
                }
                if (noLeftLimit) {
                    return matchedLine.substring(0, matchedLine.indexOf(rightLimit)).trim();
                }
                if (matchedLine.contains(leftLimit) && matchedLine.contains(rightLimit) && matchedLine.indexOf(rightLimit) > matchedLine.indexOf(leftLimit) + 1) {
                    return matchedLine.substring(matchedLine.indexOf(leftLimit) + 1, matchedLine.indexOf(rightLimit)).trim();
                }
            }
        }
        return "";
    }
}

