/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand.ipmi;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.exception.ControlledSshException;
import org.sentrysoftware.metricshub.engine.common.exception.IpmiCommandForSolarisException;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandConfiguration;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandService;
import org.sentrysoftware.metricshub.extension.oscommand.SshConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixIpmiCriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnixIpmiCriterionProcessor.class);
    private static final String IPMI_SOLARIS_VERSION_NOT_IDENTIFIED = "Hostname %s - Could not identify Solaris version %s. Exception: %s";

    public CriterionTestResult processUnixIpmiDetection(DeviceKind hostType, TelemetryManager telemetryManager) {
        SshConfiguration osCommandConfiguration;
        Object ipmitoolCommand = telemetryManager.getHostProperties().getIpmitoolCommand();
        SshConfiguration sshConfiguration = (SshConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(SshConfiguration.class);
        OsCommandConfiguration osCommandConfiguration2 = osCommandConfiguration = telemetryManager.getHostProperties().isLocalhost() ? (OsCommandConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(OsCommandConfiguration.class) : sshConfiguration;
        if (osCommandConfiguration == null) {
            String message = String.format("Hostname %s - No OS command configuration for this host. Returning an empty result", telemetryManager.getHostname());
            log.warn(message);
            return CriterionTestResult.builder().success(false).result("").message(message).build();
        }
        String hostname = telemetryManager.getHostname(List.of(SshConfiguration.class, OsCommandConfiguration.class));
        int defaultTimeout = osCommandConfiguration.getTimeout().intValue();
        if (ipmitoolCommand == null || ((String)ipmitoolCommand).isEmpty()) {
            ipmitoolCommand = this.buildIpmiCommand(hostType, hostname, sshConfiguration, osCommandConfiguration, defaultTimeout, telemetryManager);
            telemetryManager.getHostProperties().setIpmitoolCommand((String)ipmitoolCommand);
        }
        if (!((String)(ipmitoolCommand = (String)ipmitoolCommand + " bmc info")).startsWith("PATH=")) {
            return CriterionTestResult.builder().success(false).result("").message((String)ipmitoolCommand).build();
        }
        try {
            String result = null;
            result = this.runOsCommand((String)ipmitoolCommand, hostname, sshConfiguration, defaultTimeout, telemetryManager);
            if (result != null && !result.contains("IPMI Version")) {
                return CriterionTestResult.builder().success(false).result(result).message("Did not get the expected result from the IPMI tool command: " + (String)ipmitoolCommand).build();
            }
            telemetryManager.getHostProperties().setIpmiExecutionCount(telemetryManager.getHostProperties().getIpmiExecutionCount() + 1);
            return CriterionTestResult.builder().success(true).result(result).message("Successfully connected to the IPMI BMC chip with the in-band driver interface.").build();
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - Cannot execute the IPMI tool command %s. Exception: %s.", hostname, ipmitoolCommand, e.getMessage());
            log.debug(message, (Throwable)e);
            return CriterionTestResult.builder().success(false).message(message).build();
        }
    }

    public String buildIpmiCommand(DeviceKind hostType, String hostname, SshConfiguration sshConfiguration, OsCommandConfiguration osCommandConfiguration, int defaultTimeout, TelemetryManager telemetryManager) {
        Object ipmitoolCommand = this.doesIpmitoolRequireSudo(osCommandConfiguration) ? "PATH=$PATH:/usr/local/bin:/usr/sfw/bin;export PATH;%{SUDO:ipmitool} ipmitool -I ".replace("%{SUDO:ipmitool}", osCommandConfiguration.getSudoCommand()) : "PATH=$PATH:/usr/local/bin:/usr/sfw/bin;export PATH;ipmitool -I ";
        if (DeviceKind.SOLARIS.equals((Object)hostType)) {
            String solarisOsVersion = null;
            try {
                solarisOsVersion = this.runOsCommand("/usr/bin/uname -r", hostname, sshConfiguration, defaultTimeout, telemetryManager);
            }
            catch (Exception e) {
                String message = String.format(IPMI_SOLARIS_VERSION_NOT_IDENTIFIED, hostname, ipmitoolCommand, e.getMessage());
                log.debug(message, (Throwable)e);
                return message;
            }
            if (solarisOsVersion != null) {
                try {
                    ipmitoolCommand = this.getIpmiCommandForSolaris((String)ipmitoolCommand, hostname, solarisOsVersion);
                }
                catch (IpmiCommandForSolarisException e) {
                    String message = String.format(IPMI_SOLARIS_VERSION_NOT_IDENTIFIED, hostname, ipmitoolCommand, e.getMessage());
                    log.debug(message, (Throwable)e);
                    return message;
                }
            }
        } else {
            ipmitoolCommand = (String)ipmitoolCommand + "open";
        }
        return ipmitoolCommand;
    }

    private boolean doesIpmitoolRequireSudo(OsCommandConfiguration osCommandConfiguration) {
        return osCommandConfiguration.isUseSudo() || osCommandConfiguration.getUseSudoCommands() != null && osCommandConfiguration.getUseSudoCommands().contains("ipmitool");
    }

    public String getIpmiCommandForSolaris(String ipmitoolCommand, String hostname, String solarisOsVersion) throws IpmiCommandForSolarisException {
        String[] split = solarisOsVersion.split("\\.");
        if (split.length < 2) {
            throw new IpmiCommandForSolarisException(String.format("Unknown Solaris version (%s) for host: %s IPMI cannot be executed. Returning an empty result.", solarisOsVersion, hostname));
        }
        String solarisVersion = split[1];
        try {
            int versionInt = Integer.parseInt(solarisVersion);
            if (versionInt == 9) {
                ipmitoolCommand = (String)ipmitoolCommand + "lipmi";
            } else {
                if (versionInt < 9) {
                    throw new IpmiCommandForSolarisException(String.format("Solaris version (%s) is too old for the host: %s IPMI cannot be executed. Returning an empty result.", solarisOsVersion, hostname));
                }
                ipmitoolCommand = (String)ipmitoolCommand + "bmc";
            }
        }
        catch (NumberFormatException e) {
            throw new IpmiCommandForSolarisException("Could not identify Solaris version as a valid one.\nThe 'uname -r' command returned: " + solarisOsVersion + ".");
        }
        return ipmitoolCommand;
    }

    String runOsCommand(String ipmitoolCommand, String hostname, SshConfiguration sshConfiguration, int timeout, TelemetryManager telemetryManager) throws InterruptedException, IOException, TimeoutException, ClientException, ControlledSshException {
        return telemetryManager.getHostProperties().isLocalhost() ? OsCommandService.runLocalCommand(ipmitoolCommand, timeout, null) : OsCommandService.runSshCommand(ipmitoolCommand, hostname, sshConfiguration, timeout, null, null);
    }
}

