/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ssh;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public class Utils {
    private Utils() {
    }

    public static Charset getCharsetFromLocale(String locale, Charset defaultCharset) {
        String charsetName;
        String[] localeElements;
        Charset charset = defaultCharset;
        if (!(locale == null || locale.isEmpty() || (localeElements = locale.split("\\.")).length <= 0 || (charsetName = localeElements[localeElements.length - 1]) == null || (charsetName = charsetName.trim()).isEmpty() || "c".equalsIgnoreCase(charsetName))) {
            if ("gb".equalsIgnoreCase(charsetName)) {
                charsetName = "GBK";
            }
            try {
                charset = Charset.forName(charsetName);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
        }
        return charset;
    }

    public static Charset getCharsetFromLocale(String locale) {
        return Utils.getCharsetFromLocale(locale, StandardCharsets.UTF_8);
    }

    public static <T> void checkNonNullField(T field, String name) {
        if (field == null) {
            throw new IllegalStateException(name + " must not be null.");
        }
    }

    public static void checkArgumentNotZeroOrNegative(long argument, String name) {
        if (argument <= 0L) {
            throw new IllegalArgumentException(String.format("%s=%d must not be negative or zero.", name, argument));
        }
    }
}

