/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.jdbc;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class JdbcConfiguration
implements IConfiguration {
    private static final int DEFAULT_POSTGRESQL_PORT = 5432;
    private static final int DEFAULT_MYSQL_PORT = 3306;
    private static final int DEFAULT_ORACLE_PORT = 1521;
    private static final int DEFAULT_MSSQL_PORT = 1433;
    private static final int DEFAULT_INFORMIX_PORT = 9088;
    private static final int DEFAULT_H2_PORT = 9092;
    private static final int INVALID_PORT = -1;
    private String username;
    private char[] password;
    private char[] url;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private final Long timeout;
    private String type;
    private Integer port;
    private String database;
    private String hostname;

    public String toString() {
        return this.username != null ? "JDBC as " + this.username : "JDBC";
    }

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.username, attr -> attr != null && attr.isBlank(), () -> "Resource %s - Username value is invalid for JDBC. This resource will not be monitored. Please verify the configured username value.".formatted(resourceKey));
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> "Resource %s - Timeout value is invalid for JDBC. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.".formatted(resourceKey, this.timeout));
        if (this.url == null || this.url.length == 0) {
            StringHelper.validateConfigurationAttribute((Object)this.database, attr -> attr == null || attr.isBlank(), () -> "Resource %s - No database name configured for JDBC. Database value returned: %s. This resource will not be monitored. Please verify the configured database value.".formatted(resourceKey, this.database));
            StringHelper.validateConfigurationAttribute((Object)this.type, attr -> attr == null || attr.isBlank(), () -> "Resource %s - Invalid database type configured for JDBC. Type value returned: %s. This resource will not be monitored. Please verify the configured type value.".formatted(resourceKey, this.type));
            if (this.port == null) {
                this.port = JdbcConfiguration.getDefaultPort(this.type);
            }
            StringHelper.validateConfigurationAttribute((Object)this.port, attr -> attr < 1 || attr > 65535, () -> "Resource %s - Invalid port configured for JDBC. Port value returned: %s. This resource will not be monitored. Please verify the configured port value.".formatted(resourceKey, this.port));
            this.url = this.generateUrl();
        }
        StringHelper.validateConfigurationAttribute((Object)this.url, attr -> ((char[])attr).length == 0, () -> "Resource %s - Invalid url configured for JDBC. This resource will not be monitored. Please verify the configured url value.".formatted(resourceKey));
    }

    public IConfiguration copy() {
        return JdbcConfiguration.builder().database(this.database).password(this.password).port(this.port).timeout(this.timeout).type(this.type).username(this.username).url(this.url).hostname(this.hostname).build();
    }

    static Integer getDefaultPort(String databaseType) {
        return switch (databaseType.toLowerCase()) {
            case "postgresql" -> 5432;
            case "mysql" -> 3306;
            case "oracle" -> 1521;
            case "mssql" -> 1433;
            case "informix" -> 9088;
            case "h2" -> 9092;
            default -> -1;
        };
    }

    char[] generateUrl() {
        return switch (this.type.toLowerCase()) {
            case "postgresql" -> String.format("jdbc:postgresql://%s:%d/%s", this.hostname, this.port, this.database).toCharArray();
            case "mysql" -> String.format("jdbc:mysql://%s:%d/%s", this.hostname, this.port, this.database).toCharArray();
            case "sqlserver" -> String.format("jdbc:sqlserver://%s:%d;databaseName=%s", this.hostname, this.port, this.database).toCharArray();
            default -> new char[]{};
        };
    }

    @Generated
    private static Long $default$timeout() {
        return 120L;
    }

    @Generated
    public static JdbcConfigurationBuilder builder() {
        return new JdbcConfigurationBuilder();
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public char[] getUrl() {
        return this.url;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setUrl(char[] url) {
        this.url = url;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcConfiguration)) {
            return false;
        }
        JdbcConfiguration other = (JdbcConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        if (!Arrays.equals(this.getUrl(), other.getUrl())) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdbcConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        result = result * 59 + Arrays.hashCode(this.getUrl());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    @Generated
    public JdbcConfiguration(String username, char[] password, char[] url, Long timeout, String type, Integer port, String database, String hostname) {
        this.username = username;
        this.password = password;
        this.url = url;
        this.timeout = timeout;
        this.type = type;
        this.port = port;
        this.database = database;
        this.hostname = hostname;
    }

    @Generated
    public JdbcConfiguration() {
        this.timeout = JdbcConfiguration.$default$timeout();
    }

    @Generated
    public static class JdbcConfigurationBuilder {
        @Generated
        private String username;
        @Generated
        private char[] password;
        @Generated
        private char[] url;
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;
        @Generated
        private String type;
        @Generated
        private Integer port;
        @Generated
        private String database;
        @Generated
        private String hostname;

        @Generated
        JdbcConfigurationBuilder() {
        }

        @Generated
        public JdbcConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public JdbcConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @Generated
        public JdbcConfigurationBuilder url(char[] url) {
            this.url = url;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public JdbcConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public JdbcConfigurationBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public JdbcConfigurationBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public JdbcConfigurationBuilder database(String database) {
            this.database = database;
            return this;
        }

        @Generated
        public JdbcConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public JdbcConfiguration build() {
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = JdbcConfiguration.$default$timeout();
            }
            return new JdbcConfiguration(this.username, this.password, this.url, timeout$value, this.type, this.port, this.database, this.hostname);
        }

        @Generated
        public String toString() {
            return "JdbcConfiguration.JdbcConfigurationBuilder(username=" + this.username + ", password=" + Arrays.toString(this.password) + ", url=" + Arrays.toString(this.url) + ", timeout$value=" + this.timeout$value + ", type=" + this.type + ", port=" + this.port + ", database=" + this.database + ", hostname=" + this.hostname + ")";
        }
    }
}

