/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.jdbc;

import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SqlCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.jdbc.JdbcConfiguration;
import org.sentrysoftware.metricshub.extension.jdbc.SqlRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlCriterionProcessor.class);
    private static final String SQL_TEST_SUCCESS = "Hostname %s - SQL test succeeded. Returned result: %s.";
    @NonNull
    private SqlRequestExecutor sqlRequestExecutor;

    public CriterionTestResult process(SqlCriterion sqlCriterion, TelemetryManager telemetryManager) {
        List<List<String>> queryResult;
        if (sqlCriterion == null) {
            return CriterionTestResult.error((Criterion)sqlCriterion, (String)"Malformed criterion. Cannot perform detection.");
        }
        JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(JdbcConfiguration.class);
        if (jdbcConfiguration == null) {
            return CriterionTestResult.error((Criterion)sqlCriterion, (String)"The SQL database credentials are not configured for this host.");
        }
        String hostname = jdbcConfiguration.getHostname();
        try {
            queryResult = this.sqlRequestExecutor.executeSql(hostname, jdbcConfiguration, sqlCriterion.getQuery(), false);
        }
        catch (Exception e) {
            log.error("Hostname {} - Error executing SQL criterion: {}", (Object)hostname, (Object)e.getMessage());
            log.debug("Hostname {} - An exception occurred while executing SQL criterion.", (Object)hostname, (Object)e);
            return CriterionTestResult.error((Criterion)sqlCriterion, (String)e.getMessage());
        }
        String result = SourceTable.tableToCsv(queryResult, (String)";", (boolean)true);
        return this.checkSqlResult(hostname, result, sqlCriterion.getExpectedResult());
    }

    private CriterionTestResult checkSqlResult(String hostname, String result, String expectedResult) {
        Object message;
        boolean success = false;
        if (expectedResult == null) {
            if (result == null || result.isEmpty()) {
                message = String.format("Hostname %s - SQL test failed - The SQL test did not return any result.", hostname);
            } else {
                message = String.format(SQL_TEST_SUCCESS, hostname, result);
                success = true;
            }
        } else {
            Pattern pattern = Pattern.compile(PslUtils.psl2JavaRegex((String)expectedResult), 2);
            if (result != null && pattern.matcher(result).find()) {
                message = String.format(SQL_TEST_SUCCESS, hostname, result);
                success = true;
            } else {
                message = String.format("Hostname %s - SQL test failed - The result (%s) returned by the SQL test did not match the expected result (%s).", hostname, result, expectedResult);
                message = (String)message + String.format("Expected value: %s - returned value %s.", expectedResult, result);
            }
        }
        log.debug((String)message);
        return CriterionTestResult.builder().result(result).message((String)message).success(success).build();
    }

    @Generated
    public SqlCriterionProcessor(@NonNull SqlRequestExecutor sqlRequestExecutor) {
        if (sqlRequestExecutor == null) {
            throw new IllegalArgumentException("sqlRequestExecutor is marked non-null but is null");
        }
        this.sqlRequestExecutor = sqlRequestExecutor;
    }
}

