/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.jdbc;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.extension.jdbc.JdbcConfiguration;
import org.sentrysoftware.metricshub.extension.jdbc.client.JdbcClient;
import org.sentrysoftware.metricshub.extension.jdbc.client.SqlResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlRequestExecutor.class);

    @WithSpan(value="JDBC SQL Query")
    public List<List<String>> executeSql(@SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="jdbc.config") @NonNull JdbcConfiguration jdbcConfig, @SpanAttribute(value="sql.query") @NonNull String sqlQuery, @SpanAttribute(value="sql.showWarnings") boolean showWarnings) throws ClientException {
        if (jdbcConfig == null) {
            throw new IllegalArgumentException("jdbcConfig is marked non-null but is null");
        }
        if (sqlQuery == null) {
            throw new IllegalArgumentException("sqlQuery is marked non-null but is null");
        }
        try {
            String url = String.valueOf(jdbcConfig.getUrl());
            log.trace("Hostname {} - Executing SQL query on database {}\n- URL: {}\n- Username: {}\n- Query: {}\n- Timeout: {} s\n", new Object[]{hostname, jdbcConfig.getDatabase(), url, jdbcConfig.getUsername(), sqlQuery, jdbcConfig.getTimeout()});
            SqlResult sqlResult = JdbcClient.execute(url, jdbcConfig.getUsername(), jdbcConfig.getPassword(), sqlQuery, showWarnings, jdbcConfig.getTimeout().intValue());
            List<List<String>> results = sqlResult.getResults();
            log.trace("Hostname {} - Executed SQL query on database {}\n- URL: {}\n- Username: {}\n- Query: {}\n- Timeout: {} s\n- Result: {}", new Object[]{hostname, jdbcConfig.getDatabase(), url, jdbcConfig.getUsername(), sqlQuery, jdbcConfig.getTimeout(), results});
            return results;
        }
        catch (SQLException e) {
            log.debug("Hostname {} - SQL query failed. Stack trace:", (Object)hostname, (Object)e);
            throw new ClientException("SQL query failed on hostname " + hostname, (Exception)e);
        }
    }
}

