/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.jdbc;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SqlSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.jdbc.JdbcConfiguration;
import org.sentrysoftware.metricshub.extension.jdbc.SqlRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlSourceProcessor.class);
    @NonNull
    private SqlRequestExecutor sqlRequestExecutor;
    @NonNull
    private String connectorId;

    public SourceTable process(SqlSource sqlSource, TelemetryManager telemetryManager) {
        JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(JdbcConfiguration.class);
        if (jdbcConfiguration == null) {
            log.debug("Hostname {} - The SQL database credentials are not configured. Returning an empty table for SQL source {}. ", (Object)telemetryManager.getHostname(), (Object)sqlSource.getKey());
            return SourceTable.empty();
        }
        String hostname = jdbcConfiguration.getHostname();
        try {
            List<List<String>> results = this.sqlRequestExecutor.executeSql(hostname, jdbcConfiguration, sqlSource.getQuery(), false);
            return SourceTable.builder().table(results).build();
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)this.connectorId, (String)sqlSource.getKey(), (String)String.format("SQL Query: %s", sqlSource.getQuery()), (String)hostname, (Throwable)e);
            return SourceTable.empty();
        }
    }

    @Generated
    public SqlSourceProcessor(@NonNull SqlRequestExecutor sqlRequestExecutor, @NonNull String connectorId) {
        if (sqlRequestExecutor == null) {
            throw new IllegalArgumentException("sqlRequestExecutor is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.sqlRequestExecutor = sqlRequestExecutor;
        this.connectorId = connectorId;
    }
}

