/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.jdbc.client;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sentrysoftware.metricshub.extension.jdbc.client.DatabaseLogUtils;

public class DriverLoader {
    private static final List<String> LOADED_DRIVERS = Collections.synchronizedList(new ArrayList());

    private DriverLoader() {
    }

    public static DriverLoader getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public static List<String> getLoadedDrivers() {
        return LOADED_DRIVERS;
    }

    public synchronized void loadDriver(String driverClassName, boolean disableLogs) throws ClassNotFoundException {
        if (!LOADED_DRIVERS.contains(driverClassName)) {
            if (disableLogs) {
                DatabaseLogUtils.disableLogging(driverClassName);
            }
            Class.forName(driverClassName);
            LOADED_DRIVERS.add(driverClassName);
        }
    }

    public static void loadDriverForUrl(String url) throws SQLException {
        String driverClass = null;
        if (url.startsWith("jdbc:jtds:")) {
            driverClass = "net.sourceforge.jtds.jdbc.Driver";
        } else if (url.startsWith("jdbc:sqlserver:")) {
            driverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else if (url.startsWith("jdbc:mysql:")) {
            driverClass = "com.mysql.cj.jdbc.Driver";
        } else if (url.startsWith("jdbc:oracle:thin:")) {
            driverClass = "oracle.jdbc.driver.OracleDriver";
        } else if (url.startsWith("jdbc:postgresql:")) {
            driverClass = "org.postgresql.Driver";
        } else if (url.startsWith("jdbc:informix-sqli:") || url.startsWith("jdbc:informix-direct:")) {
            driverClass = "com.informix.jdbc.IfxDriver";
        } else if (url.startsWith("jdbc:derby:")) {
            driverClass = "org.apache.derby.jdbc.EmbeddedDriver";
        } else if (url.startsWith("jdbc:h2:")) {
            driverClass = "org.h2.Driver";
        }
        if (driverClass == null) {
            throw new SQLException("No suitable driver found for the provided JDBC URL: " + url);
        }
        try {
            DriverLoader.getInstance().loadDriver(driverClass, true);
        }
        catch (Exception e) {
            throw new SQLException("Unable to load JDBC driver for URL: " + url, e);
        }
    }

    private static class SingletonHelper {
        private static final DriverLoader INSTANCE = new DriverLoader();

        private SingletonHelper() {
        }
    }
}

