/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.jdbc.client;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import org.sentrysoftware.metricshub.extension.jdbc.client.SqlResult;

public class JdbcClient {
    private JdbcClient() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static SqlResult execute(String url, String username, char[] password, String sqlQuery, boolean showWarnings, int timeout) throws SQLException {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("JDBC URL cannot be null or empty");
        }
        if (sqlQuery == null || sqlQuery.isEmpty()) {
            throw new IllegalArgumentException("SQL query cannot be null or empty");
        }
        try (Connection databaseConnection = username == null || password == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, username, new String(password));){
            SqlResult sqlResult;
            block18: {
                Statement queryStatement = databaseConnection.createStatement();
                try {
                    queryStatement.setQueryTimeout(timeout);
                    boolean isResultSet = queryStatement.execute(sqlQuery);
                    SqlResult sqlResult2 = new SqlResult();
                    do {
                        if (isResultSet) {
                            JdbcClient.processResultSet(queryStatement, sqlResult2);
                            continue;
                        }
                        if (queryStatement.getUpdateCount() == -1) break;
                    } while ((isResultSet = queryStatement.getMoreResults()) || queryStatement.getUpdateCount() != -1);
                    JdbcClient.appendWarnings(showWarnings, queryStatement, sqlResult2);
                    sqlResult = sqlResult2;
                    if (queryStatement == null) break block18;
                }
                catch (Throwable throwable) {
                    if (queryStatement != null) {
                        try {
                            queryStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                queryStatement.close();
            }
            return sqlResult;
        }
        catch (SQLException e) {
            throw new SQLException("Error executing query: " + e.getMessage(), e);
        }
    }

    private static void appendWarnings(boolean showWarnings, Statement queryStatement, SqlResult sqlResult) throws SQLException {
        if (showWarnings) {
            for (SQLWarning warning = queryStatement.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                sqlResult.appendWarnings(warning.getMessage());
            }
        }
    }

    private static void processResultSet(Statement queryStatement, SqlResult sqlResult) throws SQLException {
        try (ResultSet queryRecordSet = queryStatement.getResultSet();){
            ResultSetMetaData metadata = queryRecordSet.getMetaData();
            int numberOfColumns = metadata.getColumnCount();
            while (queryRecordSet.next()) {
                ArrayList<String> row = new ArrayList<String>();
                for (int i = 1; i < numberOfColumns + 1; ++i) {
                    row.add(queryRecordSet.getString(i));
                }
                sqlResult.addRow(row);
            }
        }
    }

    static {
        Locale.setDefault(new Locale("en", "US"));
    }
}

