/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.ping;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.deserialization.MultiValueDeserializer;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class PingConfiguration
implements IConfiguration {
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private final Long timeout;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    private String hostname;

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, "Ping", this.timeout));
    }

    public IConfiguration copy() {
        return PingConfiguration.builder().timeout(this.timeout).hostname(this.hostname).build();
    }

    @Generated
    private static Long $default$timeout() {
        return 5L;
    }

    @Generated
    public static PingConfigurationBuilder builder() {
        return new PingConfigurationBuilder();
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PingConfiguration)) {
            return false;
        }
        PingConfiguration other = (PingConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PingConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PingConfiguration(timeout=" + this.getTimeout() + ", hostname=" + this.getHostname() + ")";
    }

    @Generated
    public PingConfiguration(Long timeout, String hostname) {
        this.timeout = timeout;
        this.hostname = hostname;
    }

    @Generated
    public PingConfiguration() {
        this.timeout = PingConfiguration.$default$timeout();
    }

    @Generated
    public static class PingConfigurationBuilder {
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;
        @Generated
        private String hostname;

        @Generated
        PingConfigurationBuilder() {
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public PingConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MultiValueDeserializer.class)
        @Generated
        public PingConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public PingConfiguration build() {
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = PingConfiguration.$default$timeout();
            }
            return new PingConfiguration(timeout$value, this.hostname);
        }

        @Generated
        public String toString() {
            return "PingConfiguration.PingConfigurationBuilder(timeout$value=" + this.timeout$value + ", hostname=" + this.hostname + ")";
        }
    }
}

