/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.client;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.ipmi.client.IpmiResultConverter;
import org.sentrysoftware.ipmi.client.Utils;
import org.sentrysoftware.ipmi.client.model.Fru;
import org.sentrysoftware.ipmi.client.model.Sensor;
import org.sentrysoftware.ipmi.client.runner.GetChassisStatusRunner;
import org.sentrysoftware.ipmi.client.runner.GetFrusRunner;
import org.sentrysoftware.ipmi.client.runner.GetSensorsRunner;
import org.sentrysoftware.ipmi.core.coding.commands.chassis.GetChassisStatusResponseData;

public class IpmiClient {
    private IpmiClient() {
    }

    public static GetChassisStatusResponseData getChassisStatus(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        try (GetChassisStatusRunner runner = new GetChassisStatusRunner(ipmiConfiguration);){
            GetChassisStatusResponseData getChassisStatusResponseData = Utils.execute(runner, ipmiConfiguration.getTimeout() * 1000L);
            return getChassisStatusResponseData;
        }
    }

    public static List<Sensor> getSensors(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        try (GetSensorsRunner runner = new GetSensorsRunner(ipmiConfiguration);){
            List<Sensor> list = Utils.execute(runner, ipmiConfiguration.getTimeout() * 1000L);
            return list;
        }
    }

    public static List<Fru> getFrus(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        try (GetFrusRunner runner = new GetFrusRunner(ipmiConfiguration);){
            List<Fru> list = Utils.execute(runner, ipmiConfiguration.getTimeout() * 1000L);
            return list;
        }
    }

    public static String getChassisStatusAsStringResult(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        return IpmiResultConverter.convertResult(IpmiClient.getChassisStatus(ipmiConfiguration));
    }

    public static String getFrusAndSensorsAsStringResult(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        return IpmiResultConverter.convertResult(IpmiClient.getFrus(ipmiConfiguration), IpmiClient.getSensors(ipmiConfiguration));
    }
}

